package com.zehong.web.controller.area;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TCountyLevelRegion;
import com.zehong.system.service.ITCountyLevelRegionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 县级行政区Controller
 * 
 * @author zehong
 * @date 2024-06-06
 */
@RestController
@RequestMapping("/area/county")
public class TCountyLevelRegionController extends BaseController
{
    @Autowired
    private ITCountyLevelRegionService tCountyLevelRegionService;

    /**
     * 查询县级行政区列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TCountyLevelRegion tCountyLevelRegion)
    {
        startPage();
        List<TCountyLevelRegion> list = tCountyLevelRegionService.selectTCountyLevelRegionList(tCountyLevelRegion);
        return getDataTable(list);
    }

    /**
     * 导出县级行政区列表
     */
    @Log(title = "县级行政区", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TCountyLevelRegion tCountyLevelRegion)
    {
        List<TCountyLevelRegion> list = tCountyLevelRegionService.selectTCountyLevelRegionList(tCountyLevelRegion);
        ExcelUtil<TCountyLevelRegion> util = new ExcelUtil<TCountyLevelRegion>(TCountyLevelRegion.class);
        return util.exportExcel(list, "县级行政区数据");
    }

    /**
     * 获取县级行政区详细信息
     */
    @GetMapping(value = "/{fId}")
    public AjaxResult getInfo(@PathVariable("fId") Long fId)
    {
        return AjaxResult.success(tCountyLevelRegionService.selectTCountyLevelRegionById(fId));
    }

    /**
     * 新增县级行政区
     */
    @Log(title = "县级行政区", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TCountyLevelRegion tCountyLevelRegion)
    {
        return toAjax(tCountyLevelRegionService.insertTCountyLevelRegion(tCountyLevelRegion));
    }

    /**
     * 修改县级行政区
     */
    @Log(title = "县级行政区", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TCountyLevelRegion tCountyLevelRegion)
    {
        return toAjax(tCountyLevelRegionService.updateTCountyLevelRegion(tCountyLevelRegion));
    }

    /**
     * 删除县级行政区
     */
    @Log(title = "县级行政区", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fIds}")
    public AjaxResult remove(@PathVariable Long[] fIds)
    {
        return toAjax(tCountyLevelRegionService.deleteTCountyLevelRegionByIds(fIds));
    }

    /**
     * 获取系统设置县
     * @return
     */
    @GetMapping("/getDefaultCountyList")
    public AjaxResult getDefaultCountyList(){
        return AjaxResult.success(tCountyLevelRegionService.getDefaultCountyList());
    }
}
