import Vue from 'vue'
import VueRouter from 'vue-router'
import Layout from '../views/Layout/Layout.vue'
import METHOD from '../utils/methods'
import store from '../store'

Vue.use(VueRouter)

const baseRouterMap = [
  {
    path: '/',
    redirect: '/login'
  },
  {
    path: '/login',
    name: 'Login',
    hidden: true,
    component: () => import('@/views/Login/Login.vue')
  },
  {
    path: '/register',
    name: 'zhuce',
    hidden: true,
    component: () => import('@/views/Register.vue')
  },
  {
    path: '/search',
    name: 'chaxun',
    hidden: true,
    component: () => import('@/views/Search.vue')
  },
  {
    path: '/404',
    name: '404',
    hidden: true,
    component: () => import('@/views/404.vue')
  },
  {
    path: '*', redirect: '/404', hidden: true,
  },
  {
    path: '/homr',
    name: 'homepage',
    component: Layout,
    redirect: '/Home',
    meta: {
      title: '首页',
      icon: 'iconfont iconziyuan',
    },
    children: [
      {
        path: '/Home',
        component: () => import('@/views/Home.vue')
      }
    ]
  },
  /* 左侧菜单不显示的 */
  {
    path: '/personal',
    name: 'gr',
    component: Layout,
    redirect: '/Personal',
    meta: {
      title: '个人中心',
    },
    children: [
      {
        path: '/Personal',
        component: () => import('@/views/Layout/Personal.vue')
      }
    ]
  },
  {
    path: '/EnDetail',
    name: 'gr',
    component: Layout,
    redirect: '/EnseListDetail',
    meta: {
      title: '企业详情',
    },
    children: [
      {
        path: '/EnseListDetail',
        component: () => import('@/views/EnseList/EnseListDetail.vue')
      }
    ]
  },
];

export const defalutRouterMap = [
  {
    path: '/EnDetail',
    name: 'gr',
    component: Layout,
    redirect: '/EnseListDetail',
    isNotMenu: true,
    meta: {
      title: '企业详情',
    },
    children: [
      {
        path: '/EnseListDetail',
        component: () => import('@/views/GIS/GIS_高德.vue')
      }
    ]
  },
  {
    path: '/tongji',
    name: 'tjy',
    component: Layout,
    redirect: '/statistics',
    meta: {
      title: '政府统计页',
      icon: 'iconfont icontongji3',
    },
    children: [
      {
        path: '/statistics',
        name: 'tj',
        meta: {
          title: '政府统计页',
          icon: '',
        },
        component: () => import('@/views/statistics/statistics.vue')
      },
    ]
  },
  {
    path: '/tongji',
    name: 'qytjy',
    component: Layout,
    redirect: '/qystatistics',
    meta: {
      title: '企业统计页',
      icon: 'iconfont icontongji3',
    },
    children: [
      {
        path: '/qystatistics',
        name: 'qytj',
        meta: {
          title: '企业统计页',
          icon: '',
        },
        component: () => import('@/views/qystatistics/qystatistics.vue')
      },
    ]
  },
  {
    path: '/Hazard',
    name: 'weixian',
    component: Layout,
    redirect: '/HazardsListMg',
    meta: {
      title: '企业物品管理',
      icon: 'iconfont iconhuo',
    },
    children: [
      {
        path: '/HazardsListMg',
        name: 'wxy',
        meta: {
          title: '企业物品管理',
          icon: '',
        },
        component: () => import('@/views/Hazards/HazardsListMg.vue')
      },
    ]
  },
  {
    path: '/Safe',
    name: 'aq',
    component: Layout,
    redirect: '/SafetyDeviceMg',
    meta: {
      title: '企业安全设备',
      icon: 'iconfont iconshexiangtou',
    },
    children: [
      {
        path: '/SafetyDeviceMg',
        name: 'aqsb',
        meta: {
          title: '企业安全设备',
          icon: '',
        },
        component: () => import('@/views/SafetyDevice/SafetyDeviceMg.vue')
      },
    ]
  },
  {
    path: '/enterprises',
    name: 'qygl',
    component: Layout,
    redirect: '/EnterprisesMg',
    meta: {
      title: '企业管理',
      icon: 'iconfont icontubiao_qiyeguanli-copy',
    },
    children: [
      {
        path: '/EnterprisesMg',
        name: 'yqgls',
        meta: {
          title: '企业管理',
          icon: '',
        },
        component: () => import('@/views/Enterprises/EnterprisesMg.vue')
      },
    ]
  },
  {
    path: '/gismap',
    name: 'gis',
    component: Layout,
    redirect: '/GIS',
    meta: {
      title: '企业GIS',
      icon: 'iconfont iconditu',
    },
    children: [
      {
        path: '/GIS',
        name: 'qygs',
        meta: {
          title: '企业GIS',
          icon: '',
        },
        component: () => import('@/views/GIS/GIS.vue')
      },
    ]
  },
  {
    path: '/plans',
    name: 'yuan',
    component: Layout,
    redirect: '/PlansMg',
    meta: {
      title: '预案管理',
      icon: 'iconfont iconicon_huabanfuben1',
    },
    children: [
      {
        path: '/PlansMg',
        name: 'yua',
        meta: {
          title: '预案管理',
          icon: '',
        },
        component: () => import('@/views/Plans/PlansMg.vue')
      },
    ]
  },
  {
    path: '/yjxx',
    name: 'yujing',
    component: Layout,
    redirect: '/AlarmMg',
    meta: {
      title: '预警信息',
      icon: 'iconfont iconbaojing',
    },
    children: [
      {
        path: '/AlarmMg',
        name: 'yj',
        meta: {
          title: '预警信息',
          icon: '',
        },
        component: () => import('@/views/Alarm/AlarmMg.vue')
      },
    ]
  },
  {
    path: '/qysMap',
    name: 'qymap',
    component: Layout,
    redirect: '/qyMap',
    meta: {
      title: '企业分布',
      icon: 'iconfont iconditu',
    },
    children: [
      {
        path: '/qyMap',
        name: 'qyfb',
        meta: {
          title: '企业分布',
          icon: '',
        },
        component: () => import('@/views/qyMap/qyMap.vue')
      },
    ]
  },
  {
    path: '/Enterprise',
    name: 'Enterprise',
    component: Layout,
    redirect: '/EnseList',
    meta: {
      title: '一企一档',
      icon: 'iconfont iconqiye',
    },
    children: [
      {
        path: '/EnseList',
        name: 'EnseList',
        meta: {
          title: '企业列表',
          icon: '',
        },
        component: () => import('@/views/EnseList/EnseList.vue')
      },
    ]
  },
  {
    path: '/System',
    component: Layout,
    redirect: '/UserMg',
    meta: {
      title: '系统设置',
      icon: 'iconfont iconzidianguanli',
      id: 6
    },
    children: [
      {
        path: '/SystemCode',
        name: 'zidian',
        meta: {
          title: '字典管理',
          icon: '',
        },
        component: () => import('@/views/SystemCode/SystemCode.vue')
      },
      {
        path: '/UserMg',
        name: 'UserMg',
        meta: {
          title: '用户管理',
          icon: '',
          id: 61
        },
        component: () => import('@/views/System/UserMg.vue')
      },
      {
        path: '/RoleMg',
        name: 'RoleMg',
        meta: {
          title: '角色管理',
          icon: '',
          id: 62
        },
        component: () => import('@/views/System/RoleMg.vue')
      },
      {
        path: '/BranchMg',
        name: 'BranchMg',
        meta: {
          title: '组织机构',
          icon: '',
          id: 63
        },
        component: () => import('@/views/System/BranchMg.vue')
      },
      {
        path: '/MenuMg',
        name: 'MenuMg',
        meta: {
          title: '菜单管理',
          icon: '',
          id: 64
        },
        component: () => import('@/views/System/MenuMg.vue')
      },
      {
        path: '/APIMg',
        name: 'APIMg',
        meta: {
          title: 'API管理',
          icon: '',
          id: 65
        },
        component: () => import('@/views/System/APIMg.vue')
      },
    ]
  },
]

// const router = new VueRouter({
//   mode: 'history',
//   base: process.env.BASE_URL,
//   routes: defalutRouterMap
// });

export let asyncRouterMap = baseRouterMap;
export const createrouter = (routes: any) => new VueRouter({
  mode: 'history',
  base: process.env.BASE_URL,
  routes: routes
});
const router = createrouter( getAsyncRouterMap() );

function getAsyncRouterMap() {
  const isLogin = sessionStorage.getItem('token');
  if (isLogin) {
    return updateRouter()
  } else {
    return asyncRouterMap
  }
}
// 获取本地存储路由
function updateRouter() {
  let moudleArr = sessionStorage.getItem("moudleArr"), moudle;
  if (moudleArr) {
    moudle = JSON.parse(moudleArr);
    moudle.forEach((ele: any) => {
      ele.component = Layout;
      if (ele.children.length > 0) {
        ele.children.forEach((sele: any) => {
          let vueurl =
            (METHOD.componentUrl as any)[sele.path.replace("/", "")] +
            sele.path;
          sele.component = () => import(`@/views/${vueurl}.vue`);
        });
      }
    });
    (METHOD as any).titleArray = [...moudle];
    store.dispatch('setMoudleArr', moudle)
    return [...baseRouterMap, ...moudle]
  }
}


//路由跳转前 验证登录
router.beforeEach((to: any, from: any, next: any) => {
  if (to.path == '/register') {
    if (from.path != '/search' && sessionStorage.getItem('enterCheckInfo')) {
      sessionStorage.removeItem('enterCheckInfo')
    }
  }
  const isLogin = sessionStorage.getItem('token') ? true : false;
  let userInfo = sessionStorage.getItem("userInfo"),
    token = sessionStorage.getItem("token"),
    moudleArr = sessionStorage.getItem("moudleArr");
  if (to.path == '/login') {
    if (userInfo) sessionStorage.removeItem("userInfo");
    if (token) sessionStorage.removeItem("token");
    if (moudleArr) sessionStorage.removeItem("moudleArr");
    next()
  } else {
    let istwoAllowPage = to.path == '/register' || to.path == '/search';
    //访问其他页面先看是否有登录后存储数据 注册页查询页除外
    (isLogin || istwoAllowPage) ? next() : next('/login')
  }
})

export default router