package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import com.zehong.system.domain.modbus.ModbusDeviceData;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEquipmentInfoMapper;
import com.zehong.system.domain.TEquipmentInfo;
import com.zehong.system.service.ITEquipmentInfoService;

import javax.annotation.Resource;

/**
 * 生产设备信息Service业务层处理
 * 
 * @author zehong
 * @date 2025-05-28
 */
@Service
public class TEquipmentInfoServiceImpl implements ITEquipmentInfoService 
{
    @Resource
    private TEquipmentInfoMapper tEquipmentInfoMapper;

    /**
     * 查询生产设备信息
     * 
     * @param fEquipmentId 生产设备信息ID
     * @return 生产设备信息
     */
    @Override
    public TEquipmentInfo selectTEquipmentInfoById(Long fEquipmentId)
    {
        return tEquipmentInfoMapper.selectTEquipmentInfoById(fEquipmentId);
    }

    /**
     * 查询生产设备信息列表
     * 
     * @param tEquipmentInfo 生产设备信息
     * @return 生产设备信息
     */
    @Override
    public List<TEquipmentInfo> selectTEquipmentInfoList(TEquipmentInfo tEquipmentInfo)
    {
        return tEquipmentInfoMapper.selectTEquipmentInfoList(tEquipmentInfo);
    }

    @Override
    public List<TEquipmentInfo> getAllEquipmentList() {
        return tEquipmentInfoMapper.selectTEquipmentInfoList(null);
    }

    /**
     * 查询老化柜、标定柜信息列表
     *
     * @param types 生产设备类型
     * @return 生产设备信息集合
     */
    @Override
    public List<TEquipmentInfo> selectTEquipmentList(List<String> types)
    {
        return tEquipmentInfoMapper.selectTEquipmentList(types);
    }

    /**
     * 新增生产设备信息
     * 
     * @param tEquipmentInfo 生产设备信息
     * @return 结果
     */
    @Override
    public int insertTEquipmentInfo(TEquipmentInfo tEquipmentInfo)
    {
        return tEquipmentInfoMapper.insertTEquipmentInfo(tEquipmentInfo);
    }

    /**
     * 修改生产设备信息
     * 
     * @param tEquipmentInfo 生产设备信息
     * @return 结果
     */
    @Override
    public int updateTEquipmentInfo(TEquipmentInfo tEquipmentInfo)
    {
        return tEquipmentInfoMapper.updateTEquipmentInfo(tEquipmentInfo);
    }

    /**
     * 批量修改生产设备信息
     *
     * @param equipmentInfos 生产设备信息集合
     * @return 结果
     */
    @Override
    public int batchUpdate(List<TEquipmentInfo> equipmentInfos) {

        return tEquipmentInfoMapper.batchUpdate(equipmentInfos);
    }

    /**
     * 批量删除生产设备信息
     * 
     * @param fEquipmentIds 需要删除的生产设备信息ID
     * @return 结果
     */
    @Override
    public int deleteTEquipmentInfoByIds(Long[] fEquipmentIds)
    {
        return tEquipmentInfoMapper.deleteTEquipmentInfoByIds(fEquipmentIds);
    }

    /**
     * 删除生产设备信息信息
     * 
     * @param fEquipmentId 生产设备信息ID
     * @return 结果
     */
    @Override
    public int deleteTEquipmentInfoById(Long fEquipmentId)
    {
        return tEquipmentInfoMapper.deleteTEquipmentInfoById(fEquipmentId);
    }

    /**
     * 批量查询设备寄存器数据
     *
     * @param registerOffsets 设备寄存器地址
     * @return 设备寄存器数据
     */
    @Override
    public CompletableFuture<List<ModbusDeviceData>> readAllDevicesRegistersAsync(List<Integer> registerOffsets) {

        List<String> type = new ArrayList<>();
        type.add("1");
        type.add("2");
        List<TEquipmentInfo> tEquipmentInfos = tEquipmentInfoMapper.selectTEquipmentList(type);



        return null;
    }
}
