package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.PalletDeviceBinding;
import org.apache.ibatis.annotations.Param;

/**
 * 托盘绑定的设备列Mapper接口
 * 
 * @author zehong
 * @date 2025-06-29
 */
public interface PalletDeviceBindingMapper 
{
    /**
     * 查询托盘绑定的设备列
     * 
     * @param palletDeviceBindingId 托盘绑定的设备列ID
     * @return 托盘绑定的设备列
     */
    public PalletDeviceBinding selectPalletDeviceBindingById(Long palletDeviceBindingId);

    /**
     * 根据 老化柜 层 ip  和  index 查询
     * @param ip ip
     * @param index index
     * @return r
     */
    public PalletDeviceBinding selectByTrayIdAndIndex(@Param("ip") String ip, @Param("index") Integer index);

    /**
     * 查询托盘绑定的设备列列表
     * 
     * @param palletDeviceBinding 托盘绑定的设备列
     * @return 托盘绑定的设备列集合
     */
    public List<PalletDeviceBinding> selectPalletDeviceBindingList(PalletDeviceBinding palletDeviceBinding);

    public List<PalletDeviceBinding> getAllExcludeUnbindingTimeByTrayId(Long trayId);

    public List<PalletDeviceBinding> listByTrayCode(String trayCode);

    public int countErrorByTrayId(Long trayId);

    public int countByTrayId(Long trayId);

    public int countDeviceByTrayId(Long trayId);

    /**
     * 新增托盘绑定的设备列
     * 
     * @param palletDeviceBinding 托盘绑定的设备列
     * @return 结果
     */
    public int insertPalletDeviceBinding(PalletDeviceBinding palletDeviceBinding);

    public int resetAll(Long trayId);

    public int deleteAllByTrayId(Long trayId);

    public int batchInsertPalletDeviceBinding(@Param("palletDeviceBindingList") List<PalletDeviceBinding> palletDeviceBindingList);

    public int checkRepeat(@Param("validDeviceCodes")  List<String> validDeviceCodes);

    /**
     * 修改托盘绑定的设备列
     * 
     * @param palletDeviceBinding 托盘绑定的设备列
     * @return 结果
     */
    public int updatePalletDeviceBinding(PalletDeviceBinding palletDeviceBinding);

    public int unbindDevice(Long palletDeviceBindingId);

    public int batchUpdateDeviceCode(@Param("palletDeviceBindingList") List<PalletDeviceBinding> palletDeviceBindingList);

    public int batchUpdateAdAndStatus(@Param("palletDeviceBindingList") List<PalletDeviceBinding> palletDeviceBindingList);

    public int batchUpdateDeviceCodeAndUnbindingTime(@Param("palletDeviceBindingList") List<PalletDeviceBinding> palletDeviceBindingList);

    public int unbindAllDevice(Long trayId);

    /**
     * 删除托盘绑定的设备列
     * 
     * @param palletDeviceBindingId 托盘绑定的设备列ID
     * @return 结果
     */
    public int deletePalletDeviceBindingById(Long palletDeviceBindingId);

    /**
     * 批量删除托盘绑定的设备列
     * 
     * @param palletDeviceBindingIds 需要删除的数据ID
     * @return 结果
     */
    public int deletePalletDeviceBindingByIds(Long[] palletDeviceBindingIds);
}
