import request from '@/utils/request'

// 查询系统参数配置列表
export function listSetting(query) {
  return request({
    url: '/system/setting/list',
    method: 'get',
    params: query
  })
}

// 查询系统参数配置详细
export function getSetting(systemId) {
  return request({
    url: '/system/setting/' + systemId,
    method: 'get'
  })
}

// 新增系统参数配置
export function addSetting(data) {
  return request({
    url: '/system/setting',
    method: 'post',
    data: data
  })
}

// 修改系统参数配置
export function updateSetting(data) {
  return request({
    url: '/system/setting',
    method: 'put',
    data: data
  })
}

// 删除系统参数配置
export function delSetting(systemId) {
  return request({
    url: '/system/setting/' + systemId,
    method: 'delete'
  })
}

// 导出系统参数配置
export function exportSetting(query) {
  return request({
    url: '/system/setting/export',
    method: 'get',
    params: query
  })
}

// 导出系统参数配置
export function refreshSystemSetting(query) {
  return request({
    url: '/system/setting/refreshSystemSetting',
    method: 'get',
    params: query
  })
}
