package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 传送带IP维护对象 t_conveyor_belt_ip_maintain
 * 
 * @author zehong
 * @date 2025-11-11
 */
public class ConveyorBeltIpMaintain extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键ID */
    private Integer id;

    /** 传送带IP地址（IPv4格式） */
    @Excel(name = "传送带IP地址", readConverterExp = "I=Pv4格式")
    private String ip;

    /** 端口号 */
    private String port;

    /** 取值时的业务标识key */
    @Excel(name = "取值时的业务标识key")
    private String fetchKey;

    /** 传送带描述信息 */
    @Excel(name = "传送带描述信息")
    private String conveyorDesc;

    public void setId(Integer id) 
    {
        this.id = id;
    }

    public Integer getId() 
    {
        return id;
    }
    public void setIp(String ip) 
    {
        this.ip = ip;
    }

    public String getIp() 
    {
        return ip;
    }
    public void setFetchKey(String fetchKey) 
    {
        this.fetchKey = fetchKey;
    }

    public String getFetchKey() 
    {
        return fetchKey;
    }
    public void setConveyorDesc(String conveyorDesc) 
    {
        this.conveyorDesc = conveyorDesc;
    }

    public String getConveyorDesc() 
    {
        return conveyorDesc;
    }

    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("ip", getIp())
            .append("fetchKey", getFetchKey())
            .append("conveyorDesc", getConveyorDesc())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
