import request from '@/utils/request'

// 查询上传失败历史记录列表
export function listFailure(query) {
  return request({
    url: '/palletDevice/binding/failure/list',
    method: 'get',
    params: query
  })
}

// 查询上传失败历史记录详细
export function getFailure(id) {
  return request({
    url: '/palletDevice/binding/failure/' + id,
    method: 'get'
  })
}

// 新增上传失败历史记录
export function addFailure(data) {
  return request({
    url: '/palletDevice/binding/failure',
    method: 'post',
    data: data
  })
}

// 修改上传失败历史记录
export function updateFailure(data) {
  return request({
    url: '/palletDevice/binding/failure',
    method: 'put',
    data: data
  })
}

// 删除上传失败历史记录
export function delFailure(id) {
  return request({
    url: '/palletDevice/binding/failure/' + id,
    method: 'delete'
  })
}

// 导出上传失败历史记录
export function exportFailure(query) {
  return request({
    url: '/palletDevice/binding/failure/export',
    method: 'get',
    params: query
  })
}

export function reUpload() {
  return request({
    url: '/palletDevice/binding/failure/handleReUpload',
    method: 'get'
  })
}
