import request from '@/utils/request'

// 查询实时AD范围维护列表
export function listRange(query) {
  return request({
    url: '/system/realAdRange/list',
    method: 'get',
    params: query
  })
}

// 查询实时AD范围维护详细
export function getRange(id) {
  return request({
    url: '/system/realAdRange/' + id,
    method: 'get'
  })
}
export function getTopOne() {
  return request({
    url: '/system/realAdRange/getTopOne',
    method: 'get'
  })
}

// 新增实时AD范围维护
export function addRange(data) {
  return request({
    url: '/system/realAdRange',
    method: 'post',
    data: data
  })
}

// 修改实时AD范围维护
export function updateRange(data) {
  return request({
    url: '/system/realAdRange',
    method: 'put',
    data: data
  })
}

// 删除实时AD范围维护
export function delRange(id) {
  return request({
    url: '/system/realAdRange/' + id,
    method: 'delete'
  })
}

// 导出实时AD范围维护
export function exportRange(query) {
  return request({
    url: '/system/realAdRange/export',
    method: 'get',
    params: query
  })
}
