import request from '@/utils/request'

// 查询未上传成功的历史数据列列表
export function listHistory(query) {
  return request({
    url: '/palletDevice/binding/history/list',
    method: 'get',
    params: query
  })
}

// 查询未上传成功的历史数据列详细
export function getHistory(id) {
  return request({
    url: '/palletDevice/binding/history/' + id,
    method: 'get'
  })
}

// 新增未上传成功的历史数据列
export function addHistory(data) {
  return request({
    url: '/palletDevice/binding/history',
    method: 'post',
    data: data
  })
}

// 修改未上传成功的历史数据列
export function updateHistory(data) {
  return request({
    url: '/palletDevice/binding/history',
    method: 'put',
    data: data
  })
}

// 删除未上传成功的历史数据列
export function delHistory(id) {
  return request({
    url: '/palletDevice/binding/history/' + id,
    method: 'delete'
  })
}

// 导出未上传成功的历史数据列
export function exportHistory(query) {
  return request({
    url: '/palletDevice/binding/history/export',
    method: 'get',
    params: query
  })
}
