import request from '@/utils/request'

// 查询标定结果数据接收历史记录列表
export function listHistory(query) {
  return request({
    url: '/calibrationResult/history/list',
    method: 'get',
    params: query
  })
}

// 查询标定结果数据接收历史记录详细
export function getHistory(id) {
  return request({
    url: '/calibrationResult/history/' + id,
    method: 'get'
  })
}

// 新增标定结果数据接收历史记录
export function addHistory(data) {
  return request({
    url: '/calibrationResult/history',
    method: 'post',
    data: data
  })
}

// 修改标定结果数据接收历史记录
export function updateHistory(data) {
  return request({
    url: '/calibrationResult/history',
    method: 'put',
    data: data
  })
}

// 删除标定结果数据接收历史记录
export function delHistory(id) {
  return request({
    url: '/calibrationResult/history/' + id,
    method: 'delete'
  })
}

// 导出标定结果数据接收历史记录
export function exportHistory(query) {
  return request({
    url: '/calibrationResult/history/export',
    method: 'get',
    params: query
  })
}
