package com.zehong.system.task;

import org.springframework.context.ApplicationEvent;

/**
 * @author lenovo
 * @date 2025/6/17
 * @description 断电event
 */
public class PowerOffCommandEvent extends ApplicationEvent {
    private final String ip;
    private final int port;
    private final int layer;

    private final int registerOffset;
    private final String deviceCode;

    public PowerOffCommandEvent(Object source, String deviceCode, String ip, int port, int layer,int registerOffset) {
        super(source);
        this.deviceCode = deviceCode;
        this.ip = ip;
        this.port = port;
        this.layer = layer;
        this.registerOffset = registerOffset;
    }

    // Getters
    public String getIp() { return ip; }
    public int getPort() { return port; }
    public int getLayer() { return layer; }
    public String getDeviceCode() { return deviceCode; }

    public int getRegisterOffset() {
        return registerOffset;
    }
}
