package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.ProductStandardInspection;

/**
 * 产品主体标检单Service接口
 *
 * @author zehong
 * @date 2026-01-17
 */
public interface IProductStandardInspectionService
{
    /**
     * 查询产品主体标检单
     *
     * @param productStandardInspectionId 产品主体标检单ID
     * @return 产品主体标检单
     */
    public ProductStandardInspection selectProductStandardInspectionById(Long productStandardInspectionId);

    /**
     * 查询产品主体标检单列表
     *
     * @param productStandardInspection 产品主体标检单
     * @return 产品主体标检单集合
     */
    public List<ProductStandardInspection> selectProductStandardInspectionList(ProductStandardInspection productStandardInspection);

    public List<ProductStandardInspection> selectDuringStandardInspection();

    /**
     * 同步MES数据
     */
    public void syncMESData();

    /**
     * 新增产品主体标检单
     *
     * @param productStandardInspection 产品主体标检单
     * @return 结果
     */
    public int insertProductStandardInspection(ProductStandardInspection productStandardInspection);

    /**
     * 修改产品主体标检单
     *
     * @param productStandardInspection 产品主体标检单
     * @return 结果
     */
    public int updateProductStandardInspection(ProductStandardInspection productStandardInspection);

    /**
     * 批量删除产品主体标检单
     *
     * @param productStandardInspectionIds 需要删除的产品主体标检单ID
     * @return 结果
     */
    public int deleteProductStandardInspectionByIds(Long[] productStandardInspectionIds);

    /**
     * 删除产品主体标检单信息
     *
     * @param productStandardInspectionId 产品主体标检单ID
     * @return 结果
     */
    public int deleteProductStandardInspectionById(Long productStandardInspectionId);
}
