package com.zehong.system.service;

import java.util.List;

import com.zehong.common.core.domain.AjaxResult;
import com.zehong.system.domain.PalletDeviceBinding;
import com.zehong.system.domain.PalletDeviceUploadFailure;
import com.zehong.system.domain.PalletDeviceUploadHistory;

/**
 * 上传失败历史记录Service接口
 *
 * @author zehong
 * @date 2026-01-16
 */
public interface IPalletDeviceUploadFailureService
{
    /**
     * 查询上传失败历史记录
     *
     * @param id 上传失败历史记录ID
     * @return 上传失败历史记录
     */
    public PalletDeviceUploadFailure selectPalletDeviceUploadFailureById(Long id);

    public AjaxResult handleReUpload();
    /**
     * 查询上传失败历史记录列表
     *
     * @param palletDeviceUploadFailure 上传失败历史记录
     * @return 上传失败历史记录集合
     */
    public List<PalletDeviceUploadFailure> selectPalletDeviceUploadFailureList(PalletDeviceUploadFailure palletDeviceUploadFailure);

    /**
     * 新增上传失败历史记录
     *
     * @param palletDeviceUploadFailure 上传失败历史记录
     * @return 结果
     */
    public int insertPalletDeviceUploadFailure(PalletDeviceUploadFailure palletDeviceUploadFailure);

    public int batchInsert(List<PalletDeviceUploadFailure> palletDeviceUploadFailures);

    public int batchInsertRealTimeData(List<PalletDeviceBinding> palletDeviceBindings);
    /**
     * 修改上传失败历史记录
     *
     * @param palletDeviceUploadFailure 上传失败历史记录
     * @return 结果
     */
    public int updatePalletDeviceUploadFailure(PalletDeviceUploadFailure palletDeviceUploadFailure);

    /**
     * 批量删除上传失败历史记录
     *
     * @param ids 需要删除的上传失败历史记录ID
     * @return 结果
     */
    public int deletePalletDeviceUploadFailureByIds(Long[] ids);

    /**
     * 删除上传失败历史记录信息
     *
     * @param id 上传失败历史记录ID
     * @return 结果
     */
    public int deletePalletDeviceUploadFailureById(Long id);
}
