package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.ConveyorBeltIpMaintain;

/**
 * 传送带IP维护Service接口
 * 
 * @author zehong
 * @date 2025-11-11
 */
public interface IConveyorBeltIpMaintainService 
{
    /**
     * 查询传送带IP维护
     * 
     * @param id 传送带IP维护ID
     * @return 传送带IP维护
     */
    public ConveyorBeltIpMaintain selectConveyorBeltIpMaintainById(Integer id);

    /**
     * 查询传送带IP维护列表
     * 
     * @param conveyorBeltIpMaintain 传送带IP维护
     * @return 传送带IP维护集合
     */
    public List<ConveyorBeltIpMaintain> selectConveyorBeltIpMaintainList(ConveyorBeltIpMaintain conveyorBeltIpMaintain);

    /**
     * 根据键名查询参数配置信息
     *
     * @param configKey 参数键名
     * @return 参数键值
     */
    public String selectConfigByKey(String configKey);
    /**
     * 新增传送带IP维护
     * 
     * @param conveyorBeltIpMaintain 传送带IP维护
     * @return 结果
     */
    public int insertConveyorBeltIpMaintain(ConveyorBeltIpMaintain conveyorBeltIpMaintain);

    /**
     * 修改传送带IP维护
     * 
     * @param conveyorBeltIpMaintain 传送带IP维护
     * @return 结果
     */
    public int updateConveyorBeltIpMaintain(ConveyorBeltIpMaintain conveyorBeltIpMaintain);

    /**
     * 批量删除传送带IP维护
     * 
     * @param ids 需要删除的传送带IP维护ID
     * @return 结果
     */
    public int deleteConveyorBeltIpMaintainByIds(Integer[] ids);

    /**
     * 删除传送带IP维护信息
     * 
     * @param id 传送带IP维护ID
     * @return 结果
     */
    public int deleteConveyorBeltIpMaintainById(Integer id);
}
