import request from '@/utils/request'

// 查询生产设备报警信息列表
export function listEquipmentAlarmData(query) {
  return request({
    url: '/equipmentAlarmData/equipmentAlarmData/list',
    method: 'get',
    params: query
  })
}

// 查询生产设备报警信息详细
export function getEquipmentAlarmData(fEquipmentAlarmDataId) {
  return request({
    url: '/equipmentAlarmData/equipmentAlarmData/' + fEquipmentAlarmDataId,
    method: 'get'
  })
}

// 新增生产设备报警信息
export function addEquipmentAlarmData(data) {
  return request({
    url: '/equipmentAlarmData/equipmentAlarmData',
    method: 'post',
    data: data
  })
}

// 修改生产设备报警信息
export function updateEquipmentAlarmData(data) {
  return request({
    url: '/equipmentAlarmData/equipmentAlarmData',
    method: 'put',
    data: data
  })
}

// 删除生产设备报警信息
export function delEquipmentAlarmData(fEquipmentAlarmDataId) {
  return request({
    url: '/equipmentAlarmData/equipmentAlarmData/' + fEquipmentAlarmDataId,
    method: 'delete'
  })
}

// 导出生产设备报警信息
export function exportEquipmentAlarmData(query) {
  return request({
    url: '/equipmentAlarmData/equipmentAlarmData/export',
    method: 'get',
    params: query
  })
}