package com.zehong.system.task;
import com.zehong.system.domain.TEquipmentAlarmData;
import com.zehong.system.domain.TStoreyInfo;
import com.zehong.system.mapper.TStoreyInfoMapper;
import com.zehong.system.modbus.business.DeviceStatusReaderAndTimeSetter;
import com.zehong.system.modbus.handler.ModbusResultHandler;
import com.zehong.system.service.ITEquipmentAlarmDataService;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * @author lenovo
 * @date 2025/6/25
 * @description 上电以后 两分钟执行一次的逻辑
 */
@Component
public class DeviceCommunicationJob implements Job {
    private static final Logger log = LoggerFactory.getLogger(DeviceCommunicationJob.class);

    @Resource
    private ITEquipmentAlarmDataService alarmDataService;
    @Resource
    private DeviceStatusReaderAndTimeSetter deviceStatusReaderAndTimeSetter;
    @Resource
    private TStoreyInfoMapper tStoreyInfoMapper;

    @Autowired
    private ModbusResultHandler resultHandler;

    @Override
    public void execute(JobExecutionContext context) {
        JobDataMap data = context.getJobDetail().getJobDataMap();
        String fStoreyId = data.getString("fStoreyId");
        log.info("DeviceCommunicationJob.execute 的 fStoreyId:{}", fStoreyId);
        long l = Long.parseLong(fStoreyId);
        TStoreyInfo tStoreyInfo = tStoreyInfoMapper.selectTStoreyInfoById(l);
        try {
            // 1. 执行Modbus通信
            String s = tStoreyInfo.getfPort();
            String ip = tStoreyInfo.getfIp();
            // 501 的 27个 设备id
            List<Integer> registerOffsetsOne = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27);
            // 501 对应 27个设备读取状态 并设置时间
            deviceStatusReaderAndTimeSetter.startMultiDeviceMonitoring(ip,501, registerOffsetsOne, resultHandler, ModbusResultHandler.createDefaultStopCondition());

            // 502 端口号的 27个 设备id
             List<Integer> registerOffsetsTwo = Arrays.asList(28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,54);
            // 502 对应 27个设备读取状态 并设置时间
            deviceStatusReaderAndTimeSetter.startMultiDeviceMonitoring(ip, 502, registerOffsetsTwo, resultHandler, ModbusResultHandler.createDefaultStopCondition());

            // 503 端口号的 剩下的设备
            List<Integer> registerOffsetsThree = Arrays.asList(55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71,72);
            // 503 对应 剩下设备读取状态 并设置时间
            deviceStatusReaderAndTimeSetter.startMultiDeviceMonitoring(ip, 503, registerOffsetsThree, resultHandler, ModbusResultHandler.createDefaultStopCondition());

        } catch (Exception e) {
            // 记录异常
            TEquipmentAlarmData alarmData = new TEquipmentAlarmData();
            alarmData.setfAlarmType("03"); // 老化层
            alarmData.setfEquipmentCode(tStoreyInfo.getfStoreyCode());
            alarmData.setfAlarmData("通信失败: " + e.getMessage());
            alarmDataService.insertTEquipmentAlarmData(alarmData);
        }
    }
}
