package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TTrayInfoMapper;
import com.zehong.system.domain.TTrayInfo;
import com.zehong.system.service.ITTrayInfoService;

import javax.annotation.Resource;

/**
 * 托盘信息Service业务层处理
 * 
 * @author zehong
 * @date 2025-06-06
 */
@Service
public class TTrayInfoServiceImpl implements ITTrayInfoService 
{
    @Resource
    private TTrayInfoMapper tTrayInfoMapper;

    /**
     * 查询托盘信息
     * 
     * @param fTrayId 托盘信息ID
     * @return 托盘信息
     */
    @Override
    public TTrayInfo selectTTrayInfoById(Long fTrayId)
    {
        return tTrayInfoMapper.selectTTrayInfoById(fTrayId);
    }

    /**
     * 查询托盘信息列表
     * 
     * @param tTrayInfo 托盘信息
     * @return 托盘信息
     */
    @Override
    public List<TTrayInfo> selectTTrayInfoList(TTrayInfo tTrayInfo)
    {
        return tTrayInfoMapper.selectTTrayInfoList(tTrayInfo);
    }

    /**
     * 新增托盘信息
     * 
     * @param tTrayInfo 托盘信息
     * @return 结果
     */
    @Override
    public int insertTTrayInfo(TTrayInfo tTrayInfo)
    {
        return tTrayInfoMapper.insertTTrayInfo(tTrayInfo);
    }

    /**
     * 批量新增托盘信息
     *
     * @param tTrayInfoList 托盘信息
     * @return 批量结果
     */
    @Override
    public int batchInsertTTrayInfo(List<TTrayInfo> tTrayInfoList) {
        return tTrayInfoMapper.batchInsertTTrayInfo(tTrayInfoList);
    }

    /**
     * 修改托盘信息
     * 
     * @param tTrayInfo 托盘信息
     * @return 结果
     */
    @Override
    public int updateTTrayInfo(TTrayInfo tTrayInfo)
    {
        return tTrayInfoMapper.updateTTrayInfo(tTrayInfo);
    }

    @Override
    public int updateStatusByTrayCode(TTrayInfo tTrayInfo) {
        return tTrayInfoMapper.updateStatusByTrayCode(tTrayInfo);
    }

    @Override
    public int updateStatusByTrayId(TTrayInfo tTrayInfo) {
        return tTrayInfoMapper.initStatusByTrayId(tTrayInfo.getfTrayId());
    }

    /**
     * 批量删除托盘信息
     * 
     * @param fTrayIds 需要删除的托盘信息ID
     * @return 结果
     */
    @Override
    public int deleteTTrayInfoByIds(Long[] fTrayIds)
    {
        return tTrayInfoMapper.deleteTTrayInfoByIds(fTrayIds);
    }

    /**
     * 删除托盘信息信息
     * 
     * @param fTrayId 托盘信息ID
     * @return 结果
     */
    @Override
    public int deleteTTrayInfoById(Long fTrayId)
    {
        return tTrayInfoMapper.deleteTTrayInfoById(fTrayId);
    }
}
