package com.zehong.web.controller.equipment;

import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.SysRealTimeAdRange;
import com.zehong.system.service.ISysRealTimeAdRangeService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 实时AD范围维护Controller
 * 
 * @author zehong
 * @date 2025-11-22
 */
@RestController
@RequestMapping("/system/realAdRange")
public class SysRealTimeAdRangeController extends BaseController
{
    @Resource
    private ISysRealTimeAdRangeService sysRealTimeAdRangeService;

    /**
     * 查询实时AD范围维护列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SysRealTimeAdRange sysRealTimeAdRange)
    {
        startPage();
        List<SysRealTimeAdRange> list = sysRealTimeAdRangeService.selectSysRealTimeAdRangeList(sysRealTimeAdRange);
        return getDataTable(list);
    }

    /**
     * 获取实时AD范围维护列表
     */
    @GetMapping("/getTopOne")
    public AjaxResult getTopOne() {
        return sysRealTimeAdRangeService.getTopOne();
    }

    /**
     * 导出实时AD范围维护列表
     */
    @GetMapping("/export")
    public AjaxResult export(SysRealTimeAdRange sysRealTimeAdRange)
    {
        List<SysRealTimeAdRange> list = sysRealTimeAdRangeService.selectSysRealTimeAdRangeList(sysRealTimeAdRange);
        ExcelUtil<SysRealTimeAdRange> util = new ExcelUtil<SysRealTimeAdRange>(SysRealTimeAdRange.class);
        return util.exportExcel(list, "实时AD范围维护数据");
    }

    /**
     * 获取实时AD范围维护详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(sysRealTimeAdRangeService.selectSysRealTimeAdRangeById(id));
    }

    /**
     * 新增实时AD范围维护
     */
    @PostMapping
    public AjaxResult add(@RequestBody SysRealTimeAdRange sysRealTimeAdRange)
    {
        return AjaxResult.success(sysRealTimeAdRangeService.insertSysRealTimeAdRange(sysRealTimeAdRange));
    }

    /**
     * 修改实时AD范围维护
     */
    @PutMapping
    public AjaxResult edit(@RequestBody SysRealTimeAdRange sysRealTimeAdRange)
    {
        return toAjax(sysRealTimeAdRangeService.updateSysRealTimeAdRange(sysRealTimeAdRange));
    }

    /**
     * 删除实时AD范围维护
     */
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sysRealTimeAdRangeService.deleteSysRealTimeAdRangeByIds(ids));
    }
}
