package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.ProcessCalibrationResultHistory;

/**
 * 标定结果数据接收历史记录Mapper接口
 * 
 * @author zehong
 * @date 2025-12-01
 */
public interface ProcessCalibrationResultHistoryMapper 
{
    /**
     * 查询标定结果数据接收历史记录
     * 
     * @param id 标定结果数据接收历史记录ID
     * @return 标定结果数据接收历史记录
     */
    public ProcessCalibrationResultHistory selectProcessCalibrationResultHistoryById(Long id);

    /**
     * 查询标定结果数据接收历史记录列表
     * 
     * @param processCalibrationResultHistory 标定结果数据接收历史记录
     * @return 标定结果数据接收历史记录集合
     */
    public List<ProcessCalibrationResultHistory> selectProcessCalibrationResultHistoryList(ProcessCalibrationResultHistory processCalibrationResultHistory);

    /**
     * 新增标定结果数据接收历史记录
     * 
     * @param processCalibrationResultHistory 标定结果数据接收历史记录
     * @return 结果
     */
    public int insertProcessCalibrationResultHistory(ProcessCalibrationResultHistory processCalibrationResultHistory);

    /**
     * 修改标定结果数据接收历史记录
     * 
     * @param processCalibrationResultHistory 标定结果数据接收历史记录
     * @return 结果
     */
    public int updateProcessCalibrationResultHistory(ProcessCalibrationResultHistory processCalibrationResultHistory);

    /**
     * 删除标定结果数据接收历史记录
     * 
     * @param id 标定结果数据接收历史记录ID
     * @return 结果
     */
    public int deleteProcessCalibrationResultHistoryById(Long id);

    /**
     * 批量删除标定结果数据接收历史记录
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteProcessCalibrationResultHistoryByIds(Long[] ids);
}
