package com.zehong.web.controller.equipment;

import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.PalletDeviceUploadFailure;
import com.zehong.system.service.IPalletDeviceUploadFailureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 上传失败历史记录Controller
 *
 * @author zehong
 * @date 2026-01-16
 */
@RestController
@RequestMapping("/palletDevice/binding/failure")
public class PalletDeviceUploadFailureController extends BaseController
{
    @Autowired
    private IPalletDeviceUploadFailureService palletDeviceUploadFailureService;

    /**
     * 查询上传失败历史记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(PalletDeviceUploadFailure palletDeviceUploadFailure)
    {
        startPage();
        List<PalletDeviceUploadFailure> list = palletDeviceUploadFailureService.selectPalletDeviceUploadFailureList(palletDeviceUploadFailure);
        return getDataTable(list);
    }

    /**
     * 重新上传
     */
    @GetMapping("/handleReUpload")
    public AjaxResult handleReUpload(){
        return palletDeviceUploadFailureService.handleReUpload();
    }
    /**
     * 导出上传失败历史记录列表
     */
    @GetMapping("/export")
    public AjaxResult export(PalletDeviceUploadFailure palletDeviceUploadFailure)
    {
        List<PalletDeviceUploadFailure> list = palletDeviceUploadFailureService.selectPalletDeviceUploadFailureList(palletDeviceUploadFailure);
        ExcelUtil<PalletDeviceUploadFailure> util = new ExcelUtil<PalletDeviceUploadFailure>(PalletDeviceUploadFailure.class);
        return util.exportExcel(list, "上传失败历史记录数据");
    }

    /**
     * 获取上传失败历史记录详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(palletDeviceUploadFailureService.selectPalletDeviceUploadFailureById(id));
    }

    /**
     * 新增上传失败历史记录
     */
    @PostMapping
    public AjaxResult add(@RequestBody PalletDeviceUploadFailure palletDeviceUploadFailure)
    {
        return toAjax(palletDeviceUploadFailureService.insertPalletDeviceUploadFailure(palletDeviceUploadFailure));
    }

    /**
     * 修改上传失败历史记录
     */
    @PutMapping
    public AjaxResult edit(@RequestBody PalletDeviceUploadFailure palletDeviceUploadFailure)
    {
        return toAjax(palletDeviceUploadFailureService.updatePalletDeviceUploadFailure(palletDeviceUploadFailure));
    }

    /**
     * 删除上传失败历史记录
     */
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(palletDeviceUploadFailureService.deletePalletDeviceUploadFailureByIds(ids));
    }
}
