package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.RobotArmCommand;
import org.apache.ibatis.annotations.Param;

/**
 * 机械臂指令Mapper接口
 * 
 * @author zehong
 * @date 2025-08-04
 */
public interface RobotArmCommandMapper 
{
    /**
     * 查询机械臂指令
     * 
     * @param robotArmCommandId 机械臂指令ID
     * @return 机械臂指令
     */
    public RobotArmCommand selectRobotArmCommandById(Long robotArmCommandId);

    public RobotArmCommand findExecutingCommand(String trayCode, String storeyCode);

    public RobotArmCommand findExecutingCommandByType(String trayCode,String storeyCode,String type);

    public RobotArmCommand selectLatestPendingTray();

        public RobotArmCommand findByTrayAndStatus(@Param("trayCode") String trayCode, @Param("status") String status);
    /**
     * 查询机械臂指令列表
     * 
     * @param robotArmCommand 机械臂指令
     * @return 机械臂指令集合
     */
    public List<RobotArmCommand> selectRobotArmCommandList(RobotArmCommand robotArmCommand);

    public List<RobotArmCommand> selectTopRunningRobotArmCommands();

    public RobotArmCommand findNotCompletedCommand(String command);

    public List<RobotArmCommand> findByType(String type);

    /**
     * 新增机械臂指令
     * 
     * @param robotArmCommand 机械臂指令
     * @return 结果
     */
    public int insertRobotArmCommand(RobotArmCommand robotArmCommand);

    /**
     * 修改机械臂指令
     * 
     * @param robotArmCommand 机械臂指令
     * @return 结果
     */
    public int updateRobotArmCommand(RobotArmCommand robotArmCommand);


    /**
     * 更新执行中状态为完成状态
     */
    int updateExecutingToCompleted();

    /**
     * 获取待执行的上料指令 0-待分配位置，1-待执行；2-执行中；3-未上电；4-执行结束
     */
    List<RobotArmCommand> selectPendingLoadingCommands();

    /**
     * 获取待执行的下料指令 0-待分配位置，1-待执行；2-执行中；3-未上电；4-执行结束
     */
    List<RobotArmCommand> selectPendingUnloadingCommands();

    /**
     * 同时获取待执行的上料指令（type=0）和下料指令（type=1），各1条
     * @return 包含上料、下料指令的列表（最多2条，顺序：上料在前，下料在后）
     */
    List<RobotArmCommand> selectPendingLoadUnloadCommands();
    /**
     * 删除机械臂指令
     * 
     * @param robotArmCommandId 机械臂指令ID
     * @return 结果
     */
    public int deleteRobotArmCommandById(Long robotArmCommandId);

    /**
     * 批量删除机械臂指令
     * 
     * @param robotArmCommandIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteRobotArmCommandByIds(Long[] robotArmCommandIds);
}
