package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.ConveyorBeltIpMaintain;

/**
 * 传送带IP维护Mapper接口
 * 
 * @author zehong
 * @date 2025-11-11
 */
public interface ConveyorBeltIpMaintainMapper 
{
    /**
     * 查询传送带IP维护
     * 
     * @param id 传送带IP维护ID
     * @return 传送带IP维护
     */
    public ConveyorBeltIpMaintain selectConveyorBeltIpMaintainById(Integer id);

    /**
     * 查询传送带IP维护列表
     * 
     * @param conveyorBeltIpMaintain 传送带IP维护
     * @return 传送带IP维护集合
     */
    public List<ConveyorBeltIpMaintain> selectConveyorBeltIpMaintainList(ConveyorBeltIpMaintain conveyorBeltIpMaintain);

    /**
     * 新增传送带IP维护
     * 
     * @param conveyorBeltIpMaintain 传送带IP维护
     * @return 结果
     */
    public int insertConveyorBeltIpMaintain(ConveyorBeltIpMaintain conveyorBeltIpMaintain);

    public ConveyorBeltIpMaintain selectConfig(String fetchKey);

    /**
     * 修改传送带IP维护
     * 
     * @param conveyorBeltIpMaintain 传送带IP维护
     * @return 结果
     */
    public int updateConveyorBeltIpMaintain(ConveyorBeltIpMaintain conveyorBeltIpMaintain);

    /**
     * 删除传送带IP维护
     * 
     * @param id 传送带IP维护ID
     * @return 结果
     */
    public int deleteConveyorBeltIpMaintainById(Integer id);

    /**
     * 批量删除传送带IP维护
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteConveyorBeltIpMaintainByIds(Integer[] ids);
}
