package com.zehong.web.controller.equipment;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TPointInfo;
import com.zehong.system.service.ITPointInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 老化层点位信息Controller
 * 
 * @author zehong
 * @date 2025-06-06
 */
@RestController
@RequestMapping("/point")
public class TPointInfoController extends BaseController
{
    @Autowired
    private ITPointInfoService tPointInfoService;

    /**
     * 查询老化层点位信息列表
     */
    @PreAuthorize("@ss.hasPermi('point:point:list')")
    @GetMapping("/list")
    public TableDataInfo list(TPointInfo tPointInfo)
    {
        startPage();
        List<TPointInfo> list = tPointInfoService.selectTPointInfoList(tPointInfo);
        return getDataTable(list);
    }

    /**
     * 导出老化层点位信息列表
     */
    @PreAuthorize("@ss.hasPermi('point:point:export')")
    @Log(title = "老化层点位信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPointInfo tPointInfo)
    {
        List<TPointInfo> list = tPointInfoService.selectTPointInfoList(tPointInfo);
        ExcelUtil<TPointInfo> util = new ExcelUtil<TPointInfo>(TPointInfo.class);
        return util.exportExcel(list, "老化层点位信息数据");
    }

    /**
     * 获取老化层点位信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('point:point:query')")
    @GetMapping(value = "/{fPointId}")
    public AjaxResult getInfo(@PathVariable("fPointId") Long fPointId)
    {
        return AjaxResult.success(tPointInfoService.selectTPointInfoById(fPointId));
    }

    /**
     * 新增老化层点位信息
     */
    @PreAuthorize("@ss.hasPermi('point:point:add')")
    @Log(title = "老化层点位信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPointInfo tPointInfo)
    {
        return toAjax(tPointInfoService.insertTPointInfo(tPointInfo));
    }

    /**
     * 修改老化层点位信息
     */
    @PreAuthorize("@ss.hasPermi('point:point:edit')")
    @Log(title = "老化层点位信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPointInfo tPointInfo)
    {
        return toAjax(tPointInfoService.updateTPointInfo(tPointInfo));
    }

    /**
     * 删除老化层点位信息
     */
    @PreAuthorize("@ss.hasPermi('point:point:remove')")
    @Log(title = "老化层点位信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fPointIds}")
    public AjaxResult remove(@PathVariable Long[] fPointIds)
    {
        return toAjax(tPointInfoService.deleteTPointInfoByIds(fPointIds));
    }
}
