import request from '@/utils/request'

// 查询上传MES返回结果历史记录列表
export function listHistory(query) {
  return request({
    url: '/uploadMesResult/history/list',
    method: 'get',
    params: query
  })
}

// 查询上传MES返回结果历史记录详细
export function getHistory(id) {
  return request({
    url: '/uploadMesResult/history/' + id,
    method: 'get'
  })
}

// 新增上传MES返回结果历史记录
export function addHistory(data) {
  return request({
    url: '/uploadMesResult/history',
    method: 'post',
    data: data
  })
}

// 修改上传MES返回结果历史记录
export function updateHistory(data) {
  return request({
    url: '/uploadMesResult/history',
    method: 'put',
    data: data
  })
}

// 删除上传MES返回结果历史记录
export function delHistory(id) {
  return request({
    url: '/uploadMesResult/history/' + id,
    method: 'delete'
  })
}

// 导出上传MES返回结果历史记录
export function exportHistory(query) {
  return request({
    url: '/uploadMesResult/history/export',
    method: 'get',
    params: query
  })
}
