import request from '@/utils/request'

// 查询产品主体标检单列表
export function listInspection(query) {
  return request({
    url: '/system/inspection/list',
    method: 'get',
    params: query
  })
}

// 查询产品主体标检单详细
export function getInspection(productStandardInspectionId) {
  return request({
    url: '/system/inspection/' + productStandardInspectionId,
    method: 'get'
  })
}

// 新增产品主体标检单
export function addInspection(data) {
  return request({
    url: '/system/inspection',
    method: 'post',
    data: data
  })
}

// 修改产品主体标检单
export function updateInspection(data) {
  return request({
    url: '/system/inspection',
    method: 'put',
    data: data
  })
}

// 删除产品主体标检单
export function delInspection(productStandardInspectionId) {
  return request({
    url: '/system/inspection/' + productStandardInspectionId,
    method: 'delete'
  })
}

// 导出产品主体标检单
export function exportInspection(query) {
  return request({
    url: '/system/inspection/export',
    method: 'get',
    params: query
  })
}

export function syncMESData() {
  return request({
    url: '/system/inspection/syncMESData',
    method: 'get'
  })
}

export function listDuringStandardInspection() {
  return request({
    url: '/system/inspection/listDuringStandardInspection',
    method: 'get'
  })
}
