package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.PalletDeviceBinding;
import com.zehong.system.domain.PalletDeviceUploadHistory;
import com.zehong.system.mapper.PalletDeviceUploadHistoryMapper;
import com.zehong.system.service.IPalletDeviceUploadHistoryService;
import com.zehong.system.service.ISysConfigService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 未上传成功的历史数据列Service业务层处理
 *
 * @author zehong
 * @date 2025-11-24
 */
@Service
public class PalletDeviceUploadHistoryServiceImpl implements IPalletDeviceUploadHistoryService
{
    @Resource
    private PalletDeviceUploadHistoryMapper palletDeviceUploadHistoryMapper;

    @Resource
    private ISysConfigService sysConfigService;

    @Resource
    private IPalletDeviceUploadHistoryService palletDeviceUploadHistoryService;
    /**
     * 查询未上传成功的历史数据列
     *
     * @param id 未上传成功的历史数据列ID
     * @return 未上传成功的历史数据列
     */
    @Override
    public PalletDeviceUploadHistory selectPalletDeviceUploadHistoryById(Long id)
    {
        return palletDeviceUploadHistoryMapper.selectPalletDeviceUploadHistoryById(id);
    }

    /**
     * 查询未上传成功的历史数据列列表
     *
     * @param palletDeviceUploadHistory 未上传成功的历史数据列
     * @return 未上传成功的历史数据列
     */
    @Override
    public List<PalletDeviceUploadHistory> selectPalletDeviceUploadHistoryList(PalletDeviceUploadHistory palletDeviceUploadHistory)
    {
        return palletDeviceUploadHistoryMapper.selectPalletDeviceUploadHistoryList(palletDeviceUploadHistory);
    }

    @Override
    public int batchInsert(List<PalletDeviceUploadHistory> palletDeviceUploadHistoryList) {
        return palletDeviceUploadHistoryMapper.batchInsert(palletDeviceUploadHistoryList);
    }

    @Override
    public int batchInsertRealTimeData(List<PalletDeviceBinding> palletDeviceBindings) {
        return palletDeviceUploadHistoryMapper.batchInsertRealTimeData(palletDeviceBindings);
    }

    /**
     * 新增未上传成功的历史数据列
     *
     * @param palletDeviceUploadHistory 未上传成功的历史数据列
     * @return 结果
     */
    @Override
    public int insertPalletDeviceUploadHistory(PalletDeviceUploadHistory palletDeviceUploadHistory)
    {
        palletDeviceUploadHistory.setCreateTime(DateUtils.getNowDate());
        return palletDeviceUploadHistoryMapper.insertPalletDeviceUploadHistory(palletDeviceUploadHistory);
    }

    /**
     * 修改未上传成功的历史数据列
     *
     * @param palletDeviceUploadHistory 未上传成功的历史数据列
     * @return 结果
     */
    @Override
    public int updatePalletDeviceUploadHistory(PalletDeviceUploadHistory palletDeviceUploadHistory)
    {
        return palletDeviceUploadHistoryMapper.updatePalletDeviceUploadHistory(palletDeviceUploadHistory);
    }

    /**
     * 批量删除未上传成功的历史数据列
     *
     * @param ids 需要删除的未上传成功的历史数据列ID
     * @return 结果
     */
    @Override
    public int deletePalletDeviceUploadHistoryByIds(Long[] ids)
    {
        return palletDeviceUploadHistoryMapper.deletePalletDeviceUploadHistoryByIds(ids);
    }

    /**
     * 删除未上传成功的历史数据列信息
     *
     * @param id 未上传成功的历史数据列ID
     * @return 结果
     */
    @Override
    public int deletePalletDeviceUploadHistoryById(Long id)
    {
        return palletDeviceUploadHistoryMapper.deletePalletDeviceUploadHistoryById(id);
    }
}
