CREATE TABLE `t_process_calibration_result_history` (
    `f_id` BIGINT ( 20 ) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `f_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `f_message` LONGTEXT DEFAULT NULL COMMENT '内容',
    PRIMARY KEY ( `f_id` ) USING BTREE
) ENGINE = INNODB DEFAULT CHARSET = utf8mb4 ROW_FORMAT = DYNAMIC COMMENT = '标定结果数据接收历史记录';
http://36.138.180.82:8087/mes/pcba/devices/acceptAgingCalibrationResults
[
    {
        "motherboardCode":"PCBA2512010866",
        "concentration":"0.23",
        "deviceStatus":"1",
        "realTimeAd":0.13,
        "realTimeStatus":"1",
        "calibrationConcentration":10,
        "calibrationConcentrationStatus":"3",
        "writeTimeStatus":"1",
        "runTimeStatus":"0",
        "recordYear":"2025",
        "recordMonth":"11",
        "recordDate":"12",
        "recordHour":"13",
        "recordMinute":"14"
    }
]
ALTER TABLE `t_pallet_device_binding`
    ADD COLUMN `f_write_self_check_status` INT(16) DEFAULT NULL COMMENT '写入自检状态(可以是空，0-失败，1-成功)',
ADD COLUMN `f_relay_status` INT(16) DEFAULT NULL COMMENT '继电器状态(0-初始，1-动作)',
ADD COLUMN `f_pulse_status` INT(16) DEFAULT NULL COMMENT '脉冲状态(0-初始，1-动作)',
ADD COLUMN `f_module_status` INT(16) DEFAULT NULL COMMENT '模组状态(0-异常，1-正常)',
ADD COLUMN `f_sim_card_status` INT(16) DEFAULT NULL COMMENT 'SIM卡状态(0-异常，1-正常)',
ADD COLUMN `f_network_status` INT(16) DEFAULT NULL COMMENT '网络状态(0-异常，1-正常)';



ALTER TABLE `t_pallet_device_upload_history`
    ADD COLUMN `f_write_self_check_status` INT(16) DEFAULT NULL COMMENT '写入自检状态(可以是空，0-失败，1-成功)',
ADD COLUMN `f_relay_status` INT(16) DEFAULT NULL COMMENT '继电器状态(0-初始，1-动作)',
ADD COLUMN `f_pulse_status` INT(16) DEFAULT NULL COMMENT '脉冲状态(0-初始，1-动作)',
ADD COLUMN `f_module_status` INT(16) DEFAULT NULL COMMENT '模组状态(0-异常，1-正常)',
ADD COLUMN `f_sim_card_status` INT(16) DEFAULT NULL COMMENT 'SIM卡状态(0-异常，1-正常)',
ADD COLUMN `f_network_status` INT(16) DEFAULT NULL COMMENT '网络状态(0-异常，1-正常)';



-- 1. 删除 ERROR 触发器的“触发历史”（qrtz_fired_triggers）
DELETE FROM qrtz_fired_triggers
WHERE
        TRIGGER_NAME IN (SELECT TRIGGER_NAME FROM qrtz_triggers WHERE TRIGGER_STATE = 'ERROR')
  AND TRIGGER_GROUP IN (SELECT TRIGGER_GROUP FROM qrtz_triggers WHERE TRIGGER_STATE = 'ERROR');

-- 2. 删除 ERROR 触发器的“Cron配置”（若为Cron触发器，对应你的COMM_*任务）
DELETE FROM qrtz_cron_triggers
WHERE
        TRIGGER_NAME IN (SELECT TRIGGER_NAME FROM qrtz_triggers WHERE TRIGGER_STATE = 'ERROR')
  AND TRIGGER_GROUP IN (SELECT TRIGGER_GROUP FROM qrtz_triggers WHERE TRIGGER_STATE = 'ERROR');

-- 3. 删除 ERROR 触发器的“Simple配置”（若为Simple触发器，对应你的FINAL_*任务）
DELETE FROM qrtz_simple_triggers
WHERE
        TRIGGER_NAME IN (SELECT TRIGGER_NAME FROM qrtz_triggers WHERE TRIGGER_STATE = 'ERROR')
  AND TRIGGER_GROUP IN (SELECT TRIGGER_GROUP FROM qrtz_triggers WHERE TRIGGER_STATE = 'ERROR');

-- 4. 删除 ERROR 状态的触发器本身（qrtz_triggers）
DELETE FROM qrtz_triggers
WHERE
        TRIGGER_STATE = 'ERROR';

-- 5. 删除关联的无效 Job（若这些 Job 不再使用，对应你的COMM_*和FINAL_*任务）
DELETE FROM qrtz_job_details
WHERE
        JOB_NAME IN (
        SELECT JOB_NAME FROM qrtz_triggers WHERE TRIGGER_STATE = 'ERROR'
    ) OR
        JOB_NAME LIKE 'COMM_%' OR  -- 确保清理所有旧的通信任务
        JOB_NAME LIKE 'FINAL_%';   -- 确保清理所有旧的最终任务

ALTER TABLE `t_storey_info`
    ADD COLUMN `f_estimated_end_time` datetime DEFAULT NULL COMMENT '预计老化结束时间';

-- src/assets/styles/variables.scss $sideBarWidth  修改左边栏宽度
SET @row_number = 0;

UPDATE t_pallet_device_binding
SET f_motherboard_code = CONCAT('PCBA20250603', LPAD(@row_number := @row_number + 1, 6, '0'))
WHERE f_tray_id = 1
    ORDER BY f_pallet_device_binding_id; -- 按ID排序保证顺序

update t_pallet_device_binding set f_calibration_unbind_status = 0 where f_tray_id = 1;

读继电器不读脉冲 relayStatus(继电器)  pulseStatus(脉冲)
update t_pallet_device_binding
set f_product_standard_inspection_number = 'ZTBJ009',
    f_storey_code = '1-2',
    f_device_status = '1',
    f_record_year = '2026',
    f_record_month = '1',
    f_record_date = '22',
    f_record_hour = '14',
    f_record_minute = '20',
    f_write_time_status = '1',
    f_concentration = '20',
    f_run_time_status = '1',
    f_real_time_ad = '10',
    f_real_time_ad_status = '1',
    f_write_self_check_status = 1,
    f_relay_status = 1,
    f_module_status = 1,
    f_sim_card_status = 1,
    f_network_status = 1 where  f_tray_id = 1 and f_motherboard_code is not null


    读脉冲不读继电器 relayStatus(继电器)  pulseStatus(脉冲)
update t_pallet_device_binding
set f_product_standard_inspection_number = 'ZTBJ011',
    f_storey_code = '1-2',
    f_device_status = '1',
    f_record_year = '2026',
    f_record_month = '2',
    f_record_date = '2',
    f_record_hour = '9',
    f_record_minute = '48',
    f_write_time_status = '1',
    f_concentration = '20',
    f_run_time_status = '1',
    f_real_time_ad = '10',
    f_real_time_ad_status = '1',
    f_write_self_check_status = 1,
    f_pulse_status = 1,
    f_module_status = 1,
    f_sim_card_status = 1,
    f_network_status = 1 where  f_tray_id = 1 and f_motherboard_code is not null




    @T-001/@C3_1/4/10.0/@C3_2/4/10.0/@C3_3/4/10.0/@C3_4/4/10.0/@C3_5/4/10.0/@C3_6/4/10.0/@C3_7/4/10.0/@C3_8/4/10.0/@C3_9/4/10.0/@C3_10/4/10.0/@C3_11/4/10.0/@C3_12/4/10.0/@C3_13/4/10.0/@C3_14/4/10.0/@C3_15/4/10.0/@C3_16/4/10.0/@C3_17/4/10.0/@C3_18/4/10.0/@C3_19/4/10.0/@C3_20/4/10.0/@C3_21/4/10.0/@C3_22/4/10.0/@C3_23/4/10.0/@C3_24/4/10.0/@C3_25/4/10.0/@C3_26/4/10.0/@C3_27/4/10.0/@C3_28/4/10.0/@C3_29/4/10.0/@C3_30/4/10.0/@C3_31/4/10.0/@C3_32/4/10.0/@C3_33/4/10.0/@C3_34/4/10.0/@C3_35/4/10.0/@C3_36/4/10.0/@C3_37/4/10.0/@C3_38/4/10.0/@C3_39/4/10.0/@C3_40/4/10.0/@C3_41/4/10.0/@C3_42/4/10.0/@C3_43/4/10.0/@C3_44/4/10.0/@C3_45/4/10.0/@C3_46/4/10.0/@C3_47/4/10.0/@C3_48/4/10.0/@C3_49/4/10.0/@C3_50/4/10.0/@C3_51/4/10.0/@C3_52/4/10.0/@C3_53/4/10.0/@C3_54/4/10.0/@C3_55/4/10.0/@C3_56/4/10.0/@C3_57/4/10.0/@C3_58/4/10.0/@C3_59/4/10.0/@C3_60/4/10.0/@C3_61/4/10.0/@C3_62/4/10.0/@C3_63/4/10.0/@C3_64/4/10.0/@C3_65/4/10.0/@C3_66/4/10.0/@C3_67/4/10.0/@C3_68/4/10.0/@C3_69/4/10.0/@C3_70/4/11.0/@C3_71/4/10.0/@C3_72/4/11.0/

