package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 托盘信息对象 t_tray_info
 *
 * @author zehong
 * @date 2025-06-06
 */
public class TTrayInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 托盘id */
    private Long fTrayId;

    /** 托盘编号 */
    @Excel(name = "托盘编号")
    private String fTrayCode;

    /** 绑定层编号 */
    @Excel(name = "绑定层编号")
    private String fStoreyCode;

    /** 状态：0.空闲 1.运行 */
    @Excel(name = "状态：0.空闲 1.运行 2老化完成  3标定完成")
    private String fStatus;

    /** 绑定设备数 */
    private Long boardCount;
    /** 绑定时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "绑定时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fBindingTime;

    /** 解绑时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "解绑时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fUnbindingTime;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fCreateTime;

    /** 老化开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "老化开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date fAgingStartTime;

    /** 预计结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "预计结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date estimatedEndTime;


    public void setfTrayId(Long fTrayId)
    {
        this.fTrayId = fTrayId;
    }

    public Long getfTrayId()
    {
        return fTrayId;
    }
    public void setfTrayCode(String fTrayCode)
    {
        this.fTrayCode = fTrayCode;
    }

    public String getfTrayCode()
    {
        return fTrayCode;
    }
    public void setfStoreyCode(String fStoreyCode)
    {
        this.fStoreyCode = fStoreyCode;
    }

    public String getfStoreyCode()
    {
        return fStoreyCode;
    }
    public void setfStatus(String fStatus)
    {
        this.fStatus = fStatus;
    }

    public String getfStatus()
    {
        return fStatus;
    }
    public void setfBindingTime(Date fBindingTime)
    {
        this.fBindingTime = fBindingTime;
    }

    public Date getfBindingTime()
    {
        return fBindingTime;
    }
    public void setfUnbindingTime(Date fUnbindingTime)
    {
        this.fUnbindingTime = fUnbindingTime;
    }

    public Date getfUnbindingTime()
    {
        return fUnbindingTime;
    }
    public void setfCreateTime(Date fCreateTime)
    {
        this.fCreateTime = fCreateTime;
    }

    public Date getfCreateTime()
    {
        return fCreateTime;
    }

    public Long getBoardCount() {
        return boardCount;
    }

    public void setBoardCount(Long boardCount) {
        this.boardCount = boardCount;
    }

    public Date getfAgingStartTime() {
        return fAgingStartTime;
    }

    public void setfAgingStartTime(Date fAgingStartTime) {
        this.fAgingStartTime = fAgingStartTime;
    }

    public Date getEstimatedEndTime() {
        return estimatedEndTime;
    }

    public void setEstimatedEndTime(Date estimatedEndTime) {
        this.estimatedEndTime = estimatedEndTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fTrayId", getfTrayId())
            .append("fTrayCode", getfTrayCode())
            .append("fStoreyCode", getfStoreyCode())
            .append("fStatus", getfStatus())
            .append("fBindingTime", getfBindingTime())
            .append("fUnbindingTime", getfUnbindingTime())
            .append("fCreateTime", getfCreateTime())
            .append("fAgingStartTime", getfAgingStartTime())
            .append("estimatedEndTime", getEstimatedEndTime())
            .toString();
    }
}
