package com.zehong.web.controller.equipment;

import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.ConveyorBeltIpMaintain;
import com.zehong.system.service.IConveyorBeltIpMaintainService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 传送带IP维护Controller
 * 
 * @author zehong
 * @date 2025-11-11
 */
@RestController
@RequestMapping("/conveyorBeltIp/maintain")
public class ConveyorBeltIpMaintainController extends BaseController
{
    @Resource
    private IConveyorBeltIpMaintainService conveyorBeltIpMaintainService;

    /**
     * 查询传送带IP维护列表
     */
    @GetMapping("/list")
    public TableDataInfo list(ConveyorBeltIpMaintain conveyorBeltIpMaintain)
    {
        startPage();
        List<ConveyorBeltIpMaintain> list = conveyorBeltIpMaintainService.selectConveyorBeltIpMaintainList(conveyorBeltIpMaintain);
        return getDataTable(list);
    }

    /**
     * 导出传送带IP维护列表
     */
    @GetMapping("/export")
    public AjaxResult export(ConveyorBeltIpMaintain conveyorBeltIpMaintain)
    {
        List<ConveyorBeltIpMaintain> list = conveyorBeltIpMaintainService.selectConveyorBeltIpMaintainList(conveyorBeltIpMaintain);
        ExcelUtil<ConveyorBeltIpMaintain> util = new ExcelUtil<ConveyorBeltIpMaintain>(ConveyorBeltIpMaintain.class);
        return util.exportExcel(list, "传送带IP维护数据");
    }

    /**
     * 获取传送带IP维护详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Integer id)
    {
        return AjaxResult.success(conveyorBeltIpMaintainService.selectConveyorBeltIpMaintainById(id));
    }

    /**
     * 新增传送带IP维护
     */
    @PostMapping
    public AjaxResult add(@RequestBody ConveyorBeltIpMaintain conveyorBeltIpMaintain)
    {
        return toAjax(conveyorBeltIpMaintainService.insertConveyorBeltIpMaintain(conveyorBeltIpMaintain));
    }

    /**
     * 修改传送带IP维护
     */
    @PutMapping
    public AjaxResult edit(@RequestBody ConveyorBeltIpMaintain conveyorBeltIpMaintain)
    {
        return toAjax(conveyorBeltIpMaintainService.updateConveyorBeltIpMaintain(conveyorBeltIpMaintain));
    }

    /**
     * 删除传送带IP维护
     */
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Integer[] ids)
    {
        return toAjax(conveyorBeltIpMaintainService.deleteConveyorBeltIpMaintainByIds(ids));
    }
}
