@echo off
title zhmes-agecal-admin
chcp 65001 > nul

setlocal

set "APP_HOME=%~dp0.."
set "APP_NAME=zhmes-agecal-3.5.0.jar"
set "JAVA_OPTS=-Xms1024m -Xmx2048m -Dfile.encoding=UTF-8"
set "CONFIG_LOCATION=%APP_HOME%/conf/"

echo Starting %APP_NAME% ...
echo JAVA_OPTS: %JAVA_OPTS%
echo CONFIG_LOCATION: %CONFIG_LOCATION%

cd /d "%APP_HOME%"

echo Checking configuration files...
if exist "%CONFIG_LOCATION%application.yml" (
    echo Found: application.yml
) else (
    echo ERROR: application.yml not found!
    pause
    exit /b 1
)

if exist "%CONFIG_LOCATION%application-dev.yml" (
    echo Found: application-test.yml
) else (
    echo WARNING: application-test.yml not found
)

echo Starting application with test profile...
java %JAVA_OPTS% -jar "lib/%APP_NAME%" --spring.config.location=file:%CONFIG_LOCATION% --spring.profiles.active=test

if %ERRORLEVEL% NEQ 0 (
    echo Failed to start %APP_NAME%
    pause
)

endlocal