package com.zehong.web.controller.equipment;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.system.domain.TTrayInfo;
import com.zehong.system.service.ITTrayInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 托盘信息Controller
 * 
 * @author zehong
 * @date 2025-06-06
 */
@RestController
@RequestMapping("/tray")
public class TTrayInfoController extends BaseController
{
    @Autowired
    private ITTrayInfoService tTrayInfoService;

    /**
     * 查询托盘信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TTrayInfo tTrayInfo)
    {
        startPage();
        List<TTrayInfo> list = tTrayInfoService.selectTTrayInfoList(tTrayInfo);
        return getDataTable(list);
    }

    /**
     * 导出托盘信息列表
     */
    @GetMapping("/export")
    public AjaxResult export(TTrayInfo tTrayInfo)
    {
        List<TTrayInfo> list = tTrayInfoService.selectTTrayInfoList(tTrayInfo);
        ExcelUtil<TTrayInfo> util = new ExcelUtil<TTrayInfo>(TTrayInfo.class);
        return util.exportExcel(list, "托盘信息数据");
    }

    /**
     * 获取托盘信息详细信息
     */
    @GetMapping(value = "/{fTrayId}")
    public AjaxResult getInfo(@PathVariable("fTrayId") Long fTrayId)
    {
        return AjaxResult.success(tTrayInfoService.selectTTrayInfoById(fTrayId));
    }

    /**
     * 新增托盘信息
     */
    @PostMapping
    public AjaxResult add(@RequestBody TTrayInfo tTrayInfo)
    {
        return toAjax(tTrayInfoService.insertTTrayInfo(tTrayInfo));
    }

    /**
     * 修改托盘信息
     */
    @PutMapping
    public AjaxResult edit(@RequestBody TTrayInfo tTrayInfo)
    {
        return toAjax(tTrayInfoService.updateTTrayInfo(tTrayInfo));
    }

    /**
     * 删除托盘信息
     */
	@DeleteMapping("/{fTrayIds}")
    public AjaxResult remove(@PathVariable Long[] fTrayIds)
    {
        return toAjax(tTrayInfoService.deleteTTrayInfoByIds(fTrayIds));
    }
}
