package com.zehong.system.domain;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 老化层信息对象 t_storey_info
 * 
 * @author zehong
 * @date 2025-05-29
 */
public class TStoreyInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /**状态*/
    private static Map<String,String> statusStrMap = new HashMap<String,String>(){{
        put("0","空闲");
        put("1","运行");
        put("2","故障");
        put("3","断电");
    }};

    /** 层ID */
    private Long fStoreyId;

    /** 所属老化柜ID */
    @Excel(name = "所属老化柜ID")
    private Long fEquipmentId;

    /** 设备编号 */
    private String fEquipmentCode;

    /** 层编号 */
    @Excel(name = "层编号")
    private String fStoreyCode;

    /** 托盘编号 */
    private String fTrayCode;

    /** IP地址 */
    @Excel(name = "IP地址")
    private String fIp;

    /** 端口号
     * 0 位置端口号管
     * 1 位置端口号管
     * 2 位置端口号管
     * 3 位置端口号管断电
     *
     * */
    @Excel(name = "端口号")
    private String fPort;

    /** 状态：0空闲，1运行，2故障，3断电*/
    @Excel(name = "状态：0空闲，1运行，2故障，3断电")
    private String fStatus;

    private String statusStr;

    /** 老化开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "老化开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date fAgingStartTime;


    /** 老化结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "老化结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date fAgingEndTime;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fUpdateTime;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fCreateTime;

    /** 报警时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "报警时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fAlarmTime;

    /** 投料指令 */
    private String feedingCommand;

    /** 退料指令 */
    private String blankingCommand;

    public String getfTrayCode() {
        return fTrayCode;
    }

    public void setfTrayCode(String fTrayCode) {
        this.fTrayCode = fTrayCode;
    }

    public void setfStoreyId(Long fStoreyId)
    {
        this.fStoreyId = fStoreyId;
    }

    public Long getfStoreyId() 
    {
        return fStoreyId;
    }
    public void setfEquipmentId(Long fEquipmentId) 
    {
        this.fEquipmentId = fEquipmentId;
    }

    public Long getfEquipmentId() 
    {
        return fEquipmentId;
    }
    public void setfStoreyCode(String fStoreyCode) 
    {
        this.fStoreyCode = fStoreyCode;
    }

    public String getfStoreyCode() 
    {
        return fStoreyCode;
    }

    public void setfIp(String fIp) 
    {
        this.fIp = fIp;
    }

    public String getfIp() 
    {
        return fIp;
    }
    public void setfStatus(String fStatus) 
    {
        this.fStatus = fStatus;
    }

    public String getfStatus() 
    {
        return fStatus;
    }

    public String getStatusStr() {
        return statusStrMap.get(fStatus);
    }

    public void setStatusStr(String statusStr) {
        this.statusStr = statusStr;
    }

    public void setfPort(String fPort)
    {
        this.fPort = fPort;
    }

    public String getfPort()
    {
        return fPort;
    }

    public Date getfAgingStartTime() {
        return fAgingStartTime;
    }

    public void setfAgingStartTime(Date fAgingStartTime) {
        this.fAgingStartTime = fAgingStartTime;
    }

    public void setfUpdateTime(Date fUpdateTime)
    {
        this.fUpdateTime = fUpdateTime;
    }

    public Date getfUpdateTime() 
    {
        return fUpdateTime;
    }
    public void setfCreateTime(Date fCreateTime) 
    {
        this.fCreateTime = fCreateTime;
    }

    public Date getfCreateTime() 
    {
        return fCreateTime;
    }
    public void setfAlarmTime(Date fAlarmTime) 
    {
        this.fAlarmTime = fAlarmTime;
    }

    public Date getfAlarmTime() 
    {
        return fAlarmTime;
    }

    public String getFeedingCommand() {
        return feedingCommand;
    }

    public void setFeedingCommand(String feedingCommand) {
        this.feedingCommand = feedingCommand;
    }

    public String getBlankingCommand() {
        return blankingCommand;
    }

    public void setBlankingCommand(String blankingCommand) {
        this.blankingCommand = blankingCommand;
    }

    public String getfEquipmentCode() {
        return fEquipmentCode;
    }

    public void setfEquipmentCode(String fEquipmentCode) {
        this.fEquipmentCode = fEquipmentCode;
    }

    public Date getfAgingEndTime() {
        return fAgingEndTime;
    }

    public void setfAgingEndTime(Date fAgingEndTime) {
        this.fAgingEndTime = fAgingEndTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fStoreyId", getfStoreyId())
            .append("fEquipmentId", getfEquipmentId())
            .append("fStoreyCode", getfStoreyCode())
            .append("fIp", getfIp())
            .append("fStatus", getfStatus())
            .append("fPort", getfPort())
            .append("fAgingStartTime", getfUpdateTime())
            .append("fUpdateTime", getfUpdateTime())
            .append("fCreateTime", getfCreateTime())
            .append("fAlarmTime", getfAlarmTime())
            .toString();
    }
}
