package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TEquipmentInfo;
import org.apache.ibatis.annotations.Param;

/**
 * 生产设备信息Mapper接口
 * 
 * @author zehong
 * @date 2025-05-28
 */
public interface TEquipmentInfoMapper 
{
    /**
     * 查询生产设备信息
     * 
     * @param fEquipmentId 生产设备信息ID
     * @return 生产设备信息
     */
    public TEquipmentInfo selectTEquipmentInfoById(Long fEquipmentId);
    public TEquipmentInfo selectTEquipmentInfoByCode(String fEquipmentCode);

    /**
     * 查询生产设备信息列表
     * 
     * @param tEquipmentInfo 生产设备信息
     * @return 生产设备信息集合
     */
    public List<TEquipmentInfo> selectTEquipmentInfoList(TEquipmentInfo tEquipmentInfo);

    /**
     * 查询老化柜、标定柜信息列表
     *
     * @param types 生产设备类型
     * @return 生产设备信息集合
     */
    public List<TEquipmentInfo> selectTEquipmentList(@Param("types") List<String> types);

    public List<TEquipmentInfo> getAll();

    public List<TEquipmentInfo> getAllByEquipmentCodeList(@Param("equipmentCodes") List<String> equipmentCodes);

    /**
     * 新增生产设备信息
     * 
     * @param tEquipmentInfo 生产设备信息
     * @return 结果
     */
    public int insertTEquipmentInfo(TEquipmentInfo tEquipmentInfo);

    public int insertBatch(@Param("equipmentInfos") List<TEquipmentInfo> equipmentInfos);

    /**
     * 修改生产设备信息
     * 
     * @param tEquipmentInfo 生产设备信息
     * @return 结果
     */
    public int updateTEquipmentInfo(TEquipmentInfo tEquipmentInfo);

    public int batchUpdate(@Param("equipmentInfos") List<TEquipmentInfo> equipmentInfos);

    /**
     * 删除生产设备信息
     * 
     * @param fEquipmentId 生产设备信息ID
     * @return 结果
     */
    public int deleteTEquipmentInfoById(Long fEquipmentId);

    /**
     * 批量删除生产设备信息
     * 
     * @param fEquipmentIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTEquipmentInfoByIds(Long[] fEquipmentIds);
}
