package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 产品主体标检单对象 t_product_standard_inspection
 *
 * @author zehong
 * @date 2026-01-17
 */
public class ProductStandardInspection extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long productStandardInspectionId;

    /** 出库单号 */
    @Excel(name = "出库单号")
    private String outStoreOrderNumber;

    /** 主体标检单号 */
    @Excel(name = "主体标检单号")
    private String productStandardInspectionNumber;

    /** 状态 (PENDING_STANDARD_INSPECTION-待标检;DURING_STANDARD_INSPECTION-标检中;STANDARD_INSPECTION_COMPLETED-标检完成)  */
    @Excel(name = "状态", dictType = "standard_inspection_status")
    private String status;

    /** 报检部门 */
    @Excel(name = "报检部门")
    private String inspectionDep;

    /** 删除标志，默认0，删除1 */
    private Integer deleteFlag;

    /** 物料名称 */
    @Excel(name = "物料名称")
    private String materialName;

    /** 物料代码 */
    @Excel(name = "物料代码")
    private String materialCode;

    /** 规格型号 */
    @Excel(name = "规格型号")
    private String specification;

    /** 领料数量 */
    @Excel(name = "领料数量")
    private Long issuedNum;

    /** 申请数量 */
    @Excel(name = "申请数量")
    private Long quantity;

    /** 合格数量 */
    @Excel(name = "合格数量")
    private Long qualifiedNum;

    /** 不合格数量 */
    @Excel(name = "不合格数量")
    private Long unQualifiedNum;

    /** 老化时长 */
    @Excel(name = "老化时长")
    private String agingDuration;

    /** 标定气体 */
    @Excel(name = "标定气体", dictType = "calibration_gas")
    private String calibrationGas;

    /** 报警值 */
    @Excel(name = "报警值")
    private String alarmValue;

    /** 量程 */
    @Excel(name = "量程")
    private String range;

    /** 确认标检人 */
    @Excel(name = "确认标检人")
    private String confirmQualityInspector;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;
    public void setProductStandardInspectionId(Long productStandardInspectionId)
    {
        this.productStandardInspectionId = productStandardInspectionId;
    }

    public Long getProductStandardInspectionId()
    {
        return productStandardInspectionId;
    }
    public void setOutStoreOrderNumber(String outStoreOrderNumber)
    {
        this.outStoreOrderNumber = outStoreOrderNumber;
    }

    public String getOutStoreOrderNumber()
    {
        return outStoreOrderNumber;
    }
    public void setProductStandardInspectionNumber(String productStandardInspectionNumber)
    {
        this.productStandardInspectionNumber = productStandardInspectionNumber;
    }

    public String getProductStandardInspectionNumber()
    {
        return productStandardInspectionNumber;
    }
    public void setConfirmQualityInspector(String confirmQualityInspector)
    {
        this.confirmQualityInspector = confirmQualityInspector;
    }

    public String getConfirmQualityInspector()
    {
        return confirmQualityInspector;
    }
    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks()
    {
        return remarks;
    }
    public void setStatus(String status)
    {
        this.status = status;
    }

    public String getStatus()
    {
        return status;
    }
    public void setInspectionDep(String inspectionDep)
    {
        this.inspectionDep = inspectionDep;
    }

    public String getInspectionDep()
    {
        return inspectionDep;
    }
    public void setDeleteFlag(Integer deleteFlag)
    {
        this.deleteFlag = deleteFlag;
    }

    public Integer getDeleteFlag()
    {
        return deleteFlag;
    }
    public void setMaterialName(String materialName)
    {
        this.materialName = materialName;
    }

    public String getMaterialName()
    {
        return materialName;
    }
    public void setMaterialCode(String materialCode)
    {
        this.materialCode = materialCode;
    }

    public String getMaterialCode()
    {
        return materialCode;
    }
    public void setSpecification(String specification)
    {
        this.specification = specification;
    }

    public String getSpecification()
    {
        return specification;
    }
    public void setIssuedNum(Long issuedNum)
    {
        this.issuedNum = issuedNum;
    }

    public Long getIssuedNum()
    {
        return issuedNum;
    }
    public void setQuantity(Long quantity)
    {
        this.quantity = quantity;
    }

    public Long getQuantity()
    {
        return quantity;
    }
    public void setQualifiedNum(Long qualifiedNum)
    {
        this.qualifiedNum = qualifiedNum;
    }

    public Long getQualifiedNum()
    {
        return qualifiedNum;
    }
    public void setUnQualifiedNum(Long unQualifiedNum)
    {
        this.unQualifiedNum = unQualifiedNum;
    }

    public Long getUnQualifiedNum()
    {
        return unQualifiedNum;
    }
    public void setAgingDuration(String agingDuration)
    {
        this.agingDuration = agingDuration;
    }

    public String getAgingDuration()
    {
        return agingDuration;
    }
    public void setCalibrationGas(String calibrationGas)
    {
        this.calibrationGas = calibrationGas;
    }

    public String getCalibrationGas()
    {
        return calibrationGas;
    }
    public void setAlarmValue(String alarmValue)
    {
        this.alarmValue = alarmValue;
    }

    public String getAlarmValue()
    {
        return alarmValue;
    }
    public void setRange(String range)
    {
        this.range = range;
    }

    public String getRange()
    {
        return range;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("productStandardInspectionId", getProductStandardInspectionId())
            .append("outStoreOrderNumber", getOutStoreOrderNumber())
            .append("productStandardInspectionNumber", getProductStandardInspectionNumber())
            .append("confirmQualityInspector", getConfirmQualityInspector())
            .append("remarks", getRemarks())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("inspectionDep", getInspectionDep())
            .append("createTime", getCreateTime())
            .append("deleteFlag", getDeleteFlag())
            .append("materialName", getMaterialName())
            .append("materialCode", getMaterialCode())
            .append("specification", getSpecification())
            .append("issuedNum", getIssuedNum())
            .append("quantity", getQuantity())
            .append("qualifiedNum", getQualifiedNum())
            .append("unQualifiedNum", getUnQualifiedNum())
            .append("agingDuration", getAgingDuration())
            .append("calibrationGas", getCalibrationGas())
            .append("alarmValue", getAlarmValue())
            .append("range", getRange())
            .toString();
    }
}
