import request from '@/utils/request'

// 查询托盘绑定的设备列列表
export function listBinding(query) {
  return request({
    url: '/palletDevice/binding/list',
    method: 'get',
    params: query
  })
}

// 查询托盘绑定的设备列列表
export function getAllBinding(query) {
  return request({
    url: '/palletDevice/binding/getAll',
    method: 'get',
    params: query
  })
}

// 查询托盘绑定的设备列详细
export function getBinding(palletDeviceBindingId) {
  return request({
    url: '/palletDevice/binding/' + palletDeviceBindingId,
    method: 'get'
  })
}

// 新增托盘绑定的设备列
export function addBinding(data) {
  return request({
    url: '/palletDevice/binding',
    method: 'post',
    data: data
  })
}

// 批量新增托盘绑定的设备列
export function batchAdd(data) {
  return request({
    url: '/palletDevice/binding/batchAdd',
    method: 'post',
    data: data
  })
}

// 修改托盘绑定的设备列
export function updateBinding(data) {
  return request({
    url: '/palletDevice/binding',
    method: 'put',
    data: data
  })
}

// 修改托盘绑定的设备列
export function batchUpdateDeviceCode(data) {
  return request({
    url: '/palletDevice/binding/batchUpdateDeviceCode',
    method: 'post',
    data: data
  })
}

// 删除托盘绑定的设备列
export function delBinding(palletDeviceBindingId) {
  return request({
    url: '/palletDevice/binding/' + palletDeviceBindingId,
    method: 'delete'
  })
}

// 删除托盘绑定的设备列
export function resetAll(trayId) {
  return request({
    url: '/palletDevice/binding/resetAll/' + trayId,
    method: 'get'
  })
}

// 导出托盘绑定的设备列
export function exportBinding(query) {
  return request({
    url: '/palletDevice/binding/export',
    method: 'get',
    params: query
  })
}
