package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.PalletDeviceBinding;

/**
 * 托盘绑定的设备列Service接口
 * 
 * @author zehong
 * @date 2025-06-29
 */
public interface IPalletDeviceBindingService 
{
    /**
     * 查询托盘绑定的设备列
     * 
     * @param palletDeviceBindingId 托盘绑定的设备列ID
     * @return 托盘绑定的设备列
     */
    public PalletDeviceBinding selectPalletDeviceBindingById(Long palletDeviceBindingId);

    /**
     * 查询托盘绑定的设备列列表
     * 
     * @param palletDeviceBinding 托盘绑定的设备列
     * @return 托盘绑定的设备列集合
     */
    public List<PalletDeviceBinding> selectPalletDeviceBindingList(PalletDeviceBinding palletDeviceBinding);

    /**
     * 新增托盘绑定的设备列
     * 
     * @param palletDeviceBinding 托盘绑定的设备列
     * @return 结果
     */
    public int insertPalletDeviceBinding(PalletDeviceBinding palletDeviceBinding);

    public int resetAll(Long trayId);

    public int batchInsertPalletDeviceBinding(List<PalletDeviceBinding> palletDeviceBindingList);

    public int batchUpdateDeviceCode(List<PalletDeviceBinding> palletDeviceBindingList);
    /**
     * 修改托盘绑定的设备列
     * 
     * @param palletDeviceBinding 托盘绑定的设备列
     * @return 结果
     */
    public int updatePalletDeviceBinding(PalletDeviceBinding palletDeviceBinding);

    /**
     * 批量删除托盘绑定的设备列
     * 
     * @param palletDeviceBindingIds 需要删除的托盘绑定的设备列ID
     * @return 结果
     */
    public int deletePalletDeviceBindingByIds(Long[] palletDeviceBindingIds);

    /**
     * 删除托盘绑定的设备列信息
     * 
     * @param palletDeviceBindingId 托盘绑定的设备列ID
     * @return 结果
     */
    public int deletePalletDeviceBindingById(Long palletDeviceBindingId);
}
