package com.zehong.system.service;

import java.util.List;

import com.zehong.common.core.domain.AjaxResult;
import com.zehong.system.domain.RobotArmCommand;

/**
 * 机械臂指令Service接口
 * 
 * @author zehong
 * @date 2025-08-04
 */
public interface IRobotArmCommandService 
{
    /**
     * 查询机械臂指令
     * 
     * @param robotArmCommandId 机械臂指令ID
     * @return 机械臂指令
     */
    public RobotArmCommand selectRobotArmCommandById(Long robotArmCommandId);

    /**
     * 查询机械臂指令列表
     * 
     * @param robotArmCommand 机械臂指令
     * @return 机械臂指令集合
     */
    public List<RobotArmCommand> selectRobotArmCommandList(RobotArmCommand robotArmCommand);

    public List<RobotArmCommand> selectTopRunningRobotArmCommands();

    public List<RobotArmCommand> findByType(String type);

    public int insertBlankingRobotArmCommand(RobotArmCommand robotArmCommand);

    /**
     * 新增机械臂指令
     * 
     * @param robotArmCommand 机械臂指令
     * @return 结果
     */
    public int insertRobotArmCommand(RobotArmCommand robotArmCommand);

    public void powerOnCommand(Long commandId);

    /**
     * 确认完成指令
     * @param commandId c
     * @return r
     */
    public AjaxResult sureCompletedCommand(Long commandId);
    /**
     * 修改机械臂指令
     * 
     * @param robotArmCommand 机械臂指令
     * @return 结果
     */
    public int updateRobotArmCommand(RobotArmCommand robotArmCommand);

    public int updateInstructionExecutionPriority(String priority);

    /**
     * 批量删除机械臂指令
     * 
     * @param robotArmCommandIds 需要删除的机械臂指令ID
     * @return 结果
     */
    public int deleteRobotArmCommandByIds(Long[] robotArmCommandIds);

    /**
     * 删除机械臂指令信息
     * 
     * @param robotArmCommandId 机械臂指令ID
     * @return 结果
     */
    public int deleteRobotArmCommandById(Long robotArmCommandId);

    void completeCommand(Long commandId);

    public int findNotCompletedCommand(String command);

    void generateBlankingCommand(String trayCode,String storeyCode,String command);

    void sendHomeCommand();

    void sendStopCommand();

    void sendCommand(String command);

    void markCommandTimeout(Long commandId);
    public void processPendingCommands();
}
