package com.zehong.system.service;

import java.util.List;

import com.zehong.common.core.domain.AjaxResult;
import com.zehong.system.domain.PalletDeviceUploadHistory;

/**
 * 未上传成功的历史数据列Service接口
 * 
 * @author zehong
 * @date 2025-11-24
 */
public interface IPalletDeviceUploadHistoryService 
{
    /**
     * 查询未上传成功的历史数据列
     * 
     * @param id 未上传成功的历史数据列ID
     * @return 未上传成功的历史数据列
     */
    public PalletDeviceUploadHistory selectPalletDeviceUploadHistoryById(Long id);

    /**
     * 查询未上传成功的历史数据列列表
     * 
     * @param palletDeviceUploadHistory 未上传成功的历史数据列
     * @return 未上传成功的历史数据列集合
     */
    public List<PalletDeviceUploadHistory> selectPalletDeviceUploadHistoryList(PalletDeviceUploadHistory palletDeviceUploadHistory);

    public int batchInsert(List<PalletDeviceUploadHistory> palletDeviceUploadHistoryList);

    /**
     * 新增未上传成功的历史数据列
     * 
     * @param palletDeviceUploadHistory 未上传成功的历史数据列
     * @return 结果
     */
    public int insertPalletDeviceUploadHistory(PalletDeviceUploadHistory palletDeviceUploadHistory);

    public AjaxResult handleReUpload();

    /**
     * 修改未上传成功的历史数据列
     * 
     * @param palletDeviceUploadHistory 未上传成功的历史数据列
     * @return 结果
     */
    public int updatePalletDeviceUploadHistory(PalletDeviceUploadHistory palletDeviceUploadHistory);

    /**
     * 批量删除未上传成功的历史数据列
     * 
     * @param ids 需要删除的未上传成功的历史数据列ID
     * @return 结果
     */
    public int deletePalletDeviceUploadHistoryByIds(Long[] ids);

    /**
     * 删除未上传成功的历史数据列信息
     * 
     * @param id 未上传成功的历史数据列ID
     * @return 结果
     */
    public int deletePalletDeviceUploadHistoryById(Long id);
}
