package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TTrayInfo;

/**
 * 托盘信息Service接口
 * 
 * @author zehong
 * @date 2025-06-06
 */
public interface ITTrayInfoService 
{
    /**
     * 查询托盘信息
     * 
     * @param fTrayId 托盘信息ID
     * @return 托盘信息
     */
    public TTrayInfo selectTTrayInfoById(Long fTrayId);

    /**
     * 查询托盘信息列表
     * 
     * @param tTrayInfo 托盘信息
     * @return 托盘信息集合
     */
    public List<TTrayInfo> selectTTrayInfoList(TTrayInfo tTrayInfo);

    /**
     * 新增托盘信息
     * 
     * @param tTrayInfo 托盘信息
     * @return 结果
     */
    public int insertTTrayInfo(TTrayInfo tTrayInfo);

    public int batchInsertTTrayInfo(List<TTrayInfo> tTrayInfoList);
    /**
     * 修改托盘信息
     * 
     * @param tTrayInfo 托盘信息
     * @return 结果
     */
    public int updateTTrayInfo(TTrayInfo tTrayInfo);

    public int updateStatusByTrayCode(TTrayInfo tTrayInfo);

    public int updateStatusByTrayId(TTrayInfo tTrayInfo);

    /**
     * 批量删除托盘信息
     * 
     * @param fTrayIds 需要删除的托盘信息ID
     * @return 结果
     */
    public int deleteTTrayInfoByIds(Long[] fTrayIds);

    /**
     * 删除托盘信息信息
     * 
     * @param fTrayId 托盘信息ID
     * @return 结果
     */
    public int deleteTTrayInfoById(Long fTrayId);
}
