package com.zehong.system.service;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import com.zehong.system.domain.TEquipmentInfo;
import com.zehong.system.domain.modbus.ModbusDeviceData;

/**
 * 生产设备信息Service接口
 * 
 * @author zehong
 * @date 2025-05-28
 */
public interface ITEquipmentInfoService 
{
    /**
     * 查询生产设备信息
     * 
     * @param fEquipmentId 生产设备信息ID
     * @return 生产设备信息
     */
    public TEquipmentInfo selectTEquipmentInfoById(Long fEquipmentId);

    /**
     * 查询生产设备信息列表
     * 
     * @param tEquipmentInfo 生产设备信息
     * @return 生产设备信息集合
     */
    public List<TEquipmentInfo> selectTEquipmentInfoList(TEquipmentInfo tEquipmentInfo);

    public List<TEquipmentInfo> getAllEquipmentList();

    /**
     * 查询老化柜、标定柜信息列表
     *
     * @param types 生产设备类型
     * @return 生产设备信息集合
     */
    public List<TEquipmentInfo> selectTEquipmentList(List<String> types);


    CompletableFuture<List<ModbusDeviceData>> readAllDevicesRegistersAsync(List<Integer> registerOffsets);
    /**
     * 新增生产设备信息
     * 
     * @param tEquipmentInfo 生产设备信息
     * @return 结果
     */
    public int insertTEquipmentInfo(TEquipmentInfo tEquipmentInfo);

    /**
     * 修改生产设备信息
     * 
     * @param tEquipmentInfo 生产设备信息
     * @return 结果
     */
    public int updateTEquipmentInfo(TEquipmentInfo tEquipmentInfo);

    public int batchUpdate(List<TEquipmentInfo> equipmentInfos);

    /**
     * 批量删除生产设备信息
     * 
     * @param fEquipmentIds 需要删除的生产设备信息ID
     * @return 结果
     */
    public int deleteTEquipmentInfoByIds(Long[] fEquipmentIds);

    /**
     * 删除生产设备信息信息
     * 
     * @param fEquipmentId 生产设备信息ID
     * @return 结果
     */
    public int deleteTEquipmentInfoById(Long fEquipmentId);
}
