package com.zehong.system.task;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * @author lenovo
 * @date 2025/9/24
 * @description TODO
 */
@Component
public class QuartzJobListener  implements JobListener {

    private static final Logger log = LoggerFactory.getLogger(QuartzJobListener.class);
    @Override
    public String getName() {
        return "DeviceCommunicationJobListener";
    }

    @Override
    public void jobToBeExecuted(JobExecutionContext context) {
        log.info("Job即将执行: {}", context.getJobDetail().getKey());
    }

    @Override
    public void jobExecutionVetoed(JobExecutionContext context) {
        log.warn("Job执行被否决: {}", context.getJobDetail().getKey());
    }

    @Override
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        if (jobException != null) {
            log.error("Job执行异常: {}", context.getJobDetail().getKey(), jobException);
        } else {
            log.info("Job执行完成: {}", context.getJobDetail().getKey());
        }
    }
}