package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEquipmentAlarmDataMapper;
import com.zehong.system.domain.TEquipmentAlarmData;
import com.zehong.system.service.ITEquipmentAlarmDataService;

/**
 * 生产设备报警信息Service业务层处理
 * 
 * @author zehong
 * @date 2025-06-03
 */
@Service
public class TEquipmentAlarmDataServiceImpl implements ITEquipmentAlarmDataService 
{
    @Autowired
    private TEquipmentAlarmDataMapper tEquipmentAlarmDataMapper;

    /**
     * 查询生产设备报警信息
     * 
     * @param fEquipmentAlarmDataId 生产设备报警信息ID
     * @return 生产设备报警信息
     */
    @Override
    public TEquipmentAlarmData selectTEquipmentAlarmDataById(Long fEquipmentAlarmDataId)
    {
        return tEquipmentAlarmDataMapper.selectTEquipmentAlarmDataById(fEquipmentAlarmDataId);
    }

    /**
     * 查询生产设备报警信息列表
     * 
     * @param tEquipmentAlarmData 生产设备报警信息
     * @return 生产设备报警信息
     */
    @Override
    public List<TEquipmentAlarmData> selectTEquipmentAlarmDataList(TEquipmentAlarmData tEquipmentAlarmData)
    {
        return tEquipmentAlarmDataMapper.selectTEquipmentAlarmDataList(tEquipmentAlarmData);
    }

    /**
     * 新增生产设备报警信息
     * 
     * @param tEquipmentAlarmData 生产设备报警信息
     * @return 结果
     */
    @Override
    public int insertTEquipmentAlarmData(TEquipmentAlarmData tEquipmentAlarmData)
    {
        return tEquipmentAlarmDataMapper.insertTEquipmentAlarmData(tEquipmentAlarmData);
    }

    /**
     * 修改生产设备报警信息
     * 
     * @param tEquipmentAlarmData 生产设备报警信息
     * @return 结果
     */
    @Override
    public int updateTEquipmentAlarmData(TEquipmentAlarmData tEquipmentAlarmData)
    {
        return tEquipmentAlarmDataMapper.updateTEquipmentAlarmData(tEquipmentAlarmData);
    }

    /**
     * 批量删除生产设备报警信息
     * 
     * @param fEquipmentAlarmDataIds 需要删除的生产设备报警信息ID
     * @return 结果
     */
    @Override
    public int deleteTEquipmentAlarmDataByIds(Long[] fEquipmentAlarmDataIds)
    {
        return tEquipmentAlarmDataMapper.deleteTEquipmentAlarmDataByIds(fEquipmentAlarmDataIds);
    }

    /**
     * 删除生产设备报警信息信息
     * 
     * @param fEquipmentAlarmDataId 生产设备报警信息ID
     * @return 结果
     */
    @Override
    public int deleteTEquipmentAlarmDataById(Long fEquipmentAlarmDataId)
    {
        return tEquipmentAlarmDataMapper.deleteTEquipmentAlarmDataById(fEquipmentAlarmDataId);
    }
}
