package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 实时AD范围维护对象 t_sys_real_time_ad_range
 * 
 * @author zehong
 * @date 2025-11-22
 */
public class SysRealTimeAdRange extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键ID */
    private Long id;

    /** 实时AD最小值 */
    @Excel(name = "实时AD最小值")
    private Long realTimeAdMin;

    /** 实时AD最大值 */
    @Excel(name = "实时AD最大值")
    private Long realTimeAdMax;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setRealTimeAdMin(Long realTimeAdMin) 
    {
        this.realTimeAdMin = realTimeAdMin;
    }

    public Long getRealTimeAdMin() 
    {
        return realTimeAdMin;
    }
    public void setRealTimeAdMax(Long realTimeAdMax) 
    {
        this.realTimeAdMax = realTimeAdMax;
    }

    public Long getRealTimeAdMax() 
    {
        return realTimeAdMax;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("realTimeAdMin", getRealTimeAdMin())
            .append("realTimeAdMax", getRealTimeAdMax())
            .toString();
    }
}
