package com.zehong.web.controller.equipment;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.system.domain.UploadMesResultHistory;
import com.zehong.system.service.IUploadMesResultHistoryService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 上传MES返回结果历史记录Controller
 * 
 * @author zehong
 * @date 2025-12-03
 */
@RestController
@RequestMapping("/uploadMesResult/history")
public class UploadMesResultHistoryController extends BaseController
{
    @Autowired
    private IUploadMesResultHistoryService uploadMesResultHistoryService;

    /**
     * 查询上传MES返回结果历史记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(UploadMesResultHistory uploadMesResultHistory)
    {
        startPage();
        List<UploadMesResultHistory> list = uploadMesResultHistoryService.selectUploadMesResultHistoryList(uploadMesResultHistory);
        return getDataTable(list);
    }

    /**
     * 导出上传MES返回结果历史记录列表
     */
    @GetMapping("/export")
    public AjaxResult export(UploadMesResultHistory uploadMesResultHistory)
    {
        List<UploadMesResultHistory> list = uploadMesResultHistoryService.selectUploadMesResultHistoryList(uploadMesResultHistory);
        ExcelUtil<UploadMesResultHistory> util = new ExcelUtil<UploadMesResultHistory>(UploadMesResultHistory.class);
        return util.exportExcel(list, "上传MES返回结果历史记录数据");
    }

    /**
     * 获取上传MES返回结果历史记录详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(uploadMesResultHistoryService.selectUploadMesResultHistoryById(id));
    }

    /**
     * 新增上传MES返回结果历史记录
     */
    @PostMapping
    public AjaxResult add(@RequestBody UploadMesResultHistory uploadMesResultHistory)
    {
        return toAjax(uploadMesResultHistoryService.insertUploadMesResultHistory(uploadMesResultHistory));
    }

    /**
     * 修改上传MES返回结果历史记录
     */
    @PutMapping
    public AjaxResult edit(@RequestBody UploadMesResultHistory uploadMesResultHistory)
    {
        return toAjax(uploadMesResultHistoryService.updateUploadMesResultHistory(uploadMesResultHistory));
    }

    /**
     * 删除上传MES返回结果历史记录
     */
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(uploadMesResultHistoryService.deleteUploadMesResultHistoryByIds(ids));
    }
}
