package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.ProcessCalibrationResultHistory;
import com.zehong.system.mapper.ProcessCalibrationResultHistoryMapper;
import com.zehong.system.service.IProcessCalibrationResultHistoryService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 标定结果数据接收历史记录Service业务层处理
 * 
 * @author zehong
 * @date 2025-12-01
 */
@Service
public class ProcessCalibrationResultHistoryServiceImpl implements IProcessCalibrationResultHistoryService 
{
    @Resource
    private ProcessCalibrationResultHistoryMapper processCalibrationResultHistoryMapper;

    /**
     * 查询标定结果数据接收历史记录
     * 
     * @param id 标定结果数据接收历史记录ID
     * @return 标定结果数据接收历史记录
     */
    @Override
    public ProcessCalibrationResultHistory selectProcessCalibrationResultHistoryById(Long id)
    {
        return processCalibrationResultHistoryMapper.selectProcessCalibrationResultHistoryById(id);
    }

    /**
     * 查询标定结果数据接收历史记录列表
     * 
     * @param processCalibrationResultHistory 标定结果数据接收历史记录
     * @return 标定结果数据接收历史记录
     */
    @Override
    public List<ProcessCalibrationResultHistory> selectProcessCalibrationResultHistoryList(ProcessCalibrationResultHistory processCalibrationResultHistory)
    {
        return processCalibrationResultHistoryMapper.selectProcessCalibrationResultHistoryList(processCalibrationResultHistory);
    }

    /**
     * 新增标定结果数据接收历史记录
     * 
     * @param processCalibrationResultHistory 标定结果数据接收历史记录
     * @return 结果
     */
    @Override
    public int insertProcessCalibrationResultHistory(ProcessCalibrationResultHistory processCalibrationResultHistory)
    {
        processCalibrationResultHistory.setCreateTime(DateUtils.getNowDate());
        return processCalibrationResultHistoryMapper.insertProcessCalibrationResultHistory(processCalibrationResultHistory);
    }

    /**
     * 修改标定结果数据接收历史记录
     * 
     * @param processCalibrationResultHistory 标定结果数据接收历史记录
     * @return 结果
     */
    @Override
    public int updateProcessCalibrationResultHistory(ProcessCalibrationResultHistory processCalibrationResultHistory)
    {
        return processCalibrationResultHistoryMapper.updateProcessCalibrationResultHistory(processCalibrationResultHistory);
    }

    /**
     * 批量删除标定结果数据接收历史记录
     * 
     * @param ids 需要删除的标定结果数据接收历史记录ID
     * @return 结果
     */
    @Override
    public int deleteProcessCalibrationResultHistoryByIds(Long[] ids)
    {
        return processCalibrationResultHistoryMapper.deleteProcessCalibrationResultHistoryByIds(ids);
    }

    /**
     * 删除标定结果数据接收历史记录信息
     * 
     * @param id 标定结果数据接收历史记录ID
     * @return 结果
     */
    @Override
    public int deleteProcessCalibrationResultHistoryById(Long id)
    {
        return processCalibrationResultHistoryMapper.deleteProcessCalibrationResultHistoryById(id);
    }
}
