// src/utils/sound.js
class SoundPlayer {
  constructor() {
    // 预加载音效。这里以失败音效为例
    this.errorSound = new Audio(require('@/assets/sound/error-sound.mp3'));
    this.errorSound.load();
  }

  // 播放扫描失败音效
  playScanError() {
    // 每次播放前重置到开头，确保短促音效能立即重复播放
    this.errorSound.currentTime = 0;
    const playPromise = this.errorSound.play();
    // 处理可能因浏览器策略导致的自动播放错误
    if (playPromise !== undefined) {
      playPromise.catch(e => {
        console.log('音效自动播放被阻止:', e);
      });
    }
  }
}

// 导出单例
export default new SoundPlayer();
