import request from '@/utils/request'

// 查询老化层点位信息列表
export function listPoint(query) {
  return request({
    url: '/point/list',
    method: 'get',
    params: query
  })
}

// 查询老化层点位信息详细
export function getPoint(fPointId) {
  return request({
    url: '/point/' + fPointId,
    method: 'get'
  })
}

// 新增老化层点位信息
export function addPoint(data) {
  return request({
    url: '/point',
    method: 'post',
    data: data
  })
}

// 修改老化层点位信息
export function updatePoint(data) {
  return request({
    url: '/point',
    method: 'put',
    data: data
  })
}

// 删除老化层点位信息
export function delPoint(fPointId) {
  return request({
    url: '/point/' + fPointId,
    method: 'delete'
  })
}

// 导出老化层点位信息
export function exportPoint(query) {
  return request({
    url: '/point/export',
    method: 'get',
    params: query
  })
}
