package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TPointInfoMapper;
import com.zehong.system.domain.TPointInfo;
import com.zehong.system.service.ITPointInfoService;

/**
 * 老化层点位信息Service业务层处理
 * 
 * @author zehong
 * @date 2025-06-06
 */
@Service
public class TPointInfoServiceImpl implements ITPointInfoService 
{
    @Autowired
    private TPointInfoMapper tPointInfoMapper;

    /**
     * 查询老化层点位信息
     * 
     * @param fPointId 老化层点位信息ID
     * @return 老化层点位信息
     */
    @Override
    public TPointInfo selectTPointInfoById(Long fPointId)
    {
        return tPointInfoMapper.selectTPointInfoById(fPointId);
    }

    /**
     * 查询老化层点位信息列表
     * 
     * @param tPointInfo 老化层点位信息
     * @return 老化层点位信息
     */
    @Override
    public List<TPointInfo> selectTPointInfoList(TPointInfo tPointInfo)
    {
        return tPointInfoMapper.selectTPointInfoList(tPointInfo);
    }

    /**
     * 新增老化层点位信息
     * 
     * @param tPointInfo 老化层点位信息
     * @return 结果
     */
    @Override
    public int insertTPointInfo(TPointInfo tPointInfo)
    {
        return tPointInfoMapper.insertTPointInfo(tPointInfo);
    }

    /**
     * 修改老化层点位信息
     * 
     * @param tPointInfo 老化层点位信息
     * @return 结果
     */
    @Override
    public int updateTPointInfo(TPointInfo tPointInfo)
    {
        return tPointInfoMapper.updateTPointInfo(tPointInfo);
    }

    /**
     * 批量删除老化层点位信息
     * 
     * @param fPointIds 需要删除的老化层点位信息ID
     * @return 结果
     */
    @Override
    public int deleteTPointInfoByIds(Long[] fPointIds)
    {
        return tPointInfoMapper.deleteTPointInfoByIds(fPointIds);
    }

    /**
     * 删除老化层点位信息信息
     * 
     * @param fPointId 老化层点位信息ID
     * @return 结果
     */
    @Override
    public int deleteTPointInfoById(Long fPointId)
    {
        return tPointInfoMapper.deleteTPointInfoById(fPointId);
    }
}
