package com.zehong.system.service.impl;

import com.zehong.common.constant.Constants;
import com.zehong.common.core.redis.RedisCache;
import com.zehong.common.core.text.Convert;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.ConveyorBeltIpMaintain;
import com.zehong.system.domain.SysConfig;
import com.zehong.system.mapper.ConveyorBeltIpMaintainMapper;
import com.zehong.system.service.IConveyorBeltIpMaintainService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 传送带IP维护Service业务层处理
 * 
 * @author zehong
 * @date 2025-11-11
 */
@Service
public class ConveyorBeltIpMaintainServiceImpl implements IConveyorBeltIpMaintainService 
{
    @Resource
    private ConveyorBeltIpMaintainMapper conveyorBeltIpMaintainMapper;

    @Autowired
    private RedisCache redisCache;
    /**
     * 查询传送带IP维护
     * 
     * @param id 传送带IP维护ID
     * @return 传送带IP维护
     */
    @Override
    public ConveyorBeltIpMaintain selectConveyorBeltIpMaintainById(Integer id)
    {
        return conveyorBeltIpMaintainMapper.selectConveyorBeltIpMaintainById(id);
    }

    /**
     * 查询传送带IP维护列表
     * 
     * @param conveyorBeltIpMaintain 传送带IP维护
     * @return 传送带IP维护
     */
    @Override
    public List<ConveyorBeltIpMaintain> selectConveyorBeltIpMaintainList(ConveyorBeltIpMaintain conveyorBeltIpMaintain)
    {
        return conveyorBeltIpMaintainMapper.selectConveyorBeltIpMaintainList(conveyorBeltIpMaintain);
    }

    /**
     * 查询参数键名是否存在
     *
     * @param configKey 参数键名
     * @return 结果
     */
    @Override
    public String selectConfigByKey(String configKey) {
        String configValue = Convert.toStr(redisCache.getCacheObject(configKey));
        if (StringUtils.isNotEmpty(configValue))
        {
            return configValue;
        }
        ConveyorBeltIpMaintain conveyorBeltIpMaintain = conveyorBeltIpMaintainMapper.selectConfig(configKey);
        if (conveyorBeltIpMaintain != null)
        {
            String retConfig = conveyorBeltIpMaintain.getIp() + ":" + conveyorBeltIpMaintain.getPort();
            redisCache.setCacheObject(configKey, retConfig);
            return retConfig;
        }
        return StringUtils.EMPTY;
    }
    /**
     * 新增传送带IP维护
     * 
     * @param conveyorBeltIpMaintain 传送带IP维护
     * @return 结果
     */
    @Override
    public int insertConveyorBeltIpMaintain(ConveyorBeltIpMaintain conveyorBeltIpMaintain)
    {
        conveyorBeltIpMaintain.setCreateTime(DateUtils.getNowDate());
        return conveyorBeltIpMaintainMapper.insertConveyorBeltIpMaintain(conveyorBeltIpMaintain);
    }

    /**
     * 修改传送带IP维护
     * 
     * @param conveyorBeltIpMaintain 传送带IP维护
     * @return 结果
     */
    @Override
    public int updateConveyorBeltIpMaintain(ConveyorBeltIpMaintain conveyorBeltIpMaintain)
    {
        conveyorBeltIpMaintain.setUpdateTime(DateUtils.getNowDate());
        return conveyorBeltIpMaintainMapper.updateConveyorBeltIpMaintain(conveyorBeltIpMaintain);
    }

    /**
     * 批量删除传送带IP维护
     * 
     * @param ids 需要删除的传送带IP维护ID
     * @return 结果
     */
    @Override
    public int deleteConveyorBeltIpMaintainByIds(Integer[] ids)
    {
        return conveyorBeltIpMaintainMapper.deleteConveyorBeltIpMaintainByIds(ids);
    }

    /**
     * 删除传送带IP维护信息
     * 
     * @param id 传送带IP维护ID
     * @return 结果
     */
    @Override
    public int deleteConveyorBeltIpMaintainById(Integer id)
    {
        return conveyorBeltIpMaintainMapper.deleteConveyorBeltIpMaintainById(id);
    }
}
