package com.zehong.system.task.DeviceCommJob;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * @author lenovo
 * @date 2025/9/25
 * @description TODO
 */
@Component
public class TestEmptyJob implements Job {
    private static final Logger log = LoggerFactory.getLogger(TestEmptyJob.class);
    // 无依赖注入，仅打印日志
    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            log.info("=== 最小化测试Job开始执行 ===");
            log.info("JobKey: {}", context.getJobDetail().getKey());
            log.info("TriggerKey: {}", context.getTrigger().getKey());
            log.info("当前时间: {}", new java.util.Date());
            log.info("=== 最小化测试Job执行完成 ===");
        } catch (Throwable e) {
            log.error("最小化测试Job异常：", e);
            // 主动抛出异常，观察是否影响状态（用于测试）
            throw new JobExecutionException("测试异常", e);
        }
    }
}
